/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira.versionparameter;

import com.atlassian.jira.rest.client.api.domain.Version;
import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.plugins.jira.JiraSession;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.versionparameter.JiraVersionParameterValue;
import hudson.plugins.jira.versionparameter.VersionComparator;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class JiraVersionParameterDefinition
extends ParameterDefinition {
    private static final long serialVersionUID = 4232979892748310160L;
    private String projectKey;
    private boolean showReleased = false;
    private boolean showArchived = false;
    private Pattern pattern = null;

    @DataBoundConstructor
    public JiraVersionParameterDefinition(String name, String description, String jiraProjectKey, String jiraReleasePattern, String jiraShowReleased, String jiraShowArchived) {
        super(name, description);
        this.setJiraProjectKey(jiraProjectKey);
        this.setJiraReleasePattern(jiraReleasePattern);
        this.setJiraShowReleased(jiraShowReleased);
        this.setJiraShowArchived(jiraShowArchived);
    }

    public ParameterValue createValue(StaplerRequest req) {
        String[] values = req.getParameterValues(this.getName());
        if (values == null || values.length != 1) {
            return null;
        }
        return new JiraVersionParameterValue(this.getName(), values[0]);
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject formData) {
        JiraVersionParameterValue value = (JiraVersionParameterValue)((Object)req.bindJSON(JiraVersionParameterValue.class, formData));
        return value;
    }

    public ParameterValue createValue(CLICommand command, String value) throws IOException, InterruptedException {
        return new JiraVersionParameterValue(this.getName(), value);
    }

    public List<Result> getVersions() throws IOException {
        Job contextJob = (Job)Stapler.getCurrentRequest().findAncestorObject(Job.class);
        JiraSite site = JiraSite.get(contextJob);
        if (site == null) {
            throw new IllegalStateException("Jira site needs to be configured in the project " + contextJob.getFullDisplayName());
        }
        JiraSession session = site.getSession((Item)contextJob);
        if (session == null) {
            throw new IllegalStateException("Remote access for Jira isn't configured in Jenkins");
        }
        return session.getVersions(this.projectKey).stream().sorted(VersionComparator.INSTANCE).filter(version -> this.match((Version)version)).map(version -> new Result((Version)version)).collect(Collectors.toList());
    }

    private boolean match(Version version) {
        if (this.pattern != null && !this.pattern.matcher(version.getName()).matches()) {
            return false;
        }
        if (!this.showReleased && version.isReleased()) {
            return false;
        }
        return this.showArchived || !version.isArchived();
    }

    public String getJiraReleasePattern() {
        if (this.pattern == null) {
            return "";
        }
        return this.pattern.pattern();
    }

    public void setJiraReleasePattern(String pattern) {
        this.pattern = pattern == null || pattern.isEmpty() ? null : Pattern.compile(pattern);
    }

    public String getJiraProjectKey() {
        return this.projectKey;
    }

    public void setJiraProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public String getJiraShowReleased() {
        return Boolean.toString(this.showReleased);
    }

    public void setJiraShowReleased(String showReleased) {
        this.showReleased = Boolean.parseBoolean(showReleased);
    }

    public String getJiraShowArchived() {
        return Boolean.toString(this.showArchived);
    }

    public void setJiraShowArchived(String showArchived) {
        this.showArchived = Boolean.parseBoolean(showArchived);
    }

    public static class Result {
        public final String name;
        public final Long id;

        public Result(Version version) {
            this.name = version.getName();
            this.id = version.getId();
        }
    }

    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return "Jira Release Version Parameter";
        }
    }
}

