/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.junit;

import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.tasks.junit.Messages;
import hudson.tasks.junit.TestResult;
import hudson.tasks.test.PipelineTestDetails;
import hudson.tasks.test.TestResultParser;
import java.io.File;
import java.io.IOException;
import jenkins.MasterToSlaveFileCallable;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;

@Extension
public class JUnitParser
extends TestResultParser {
    private final boolean keepLongStdio;
    private final boolean allowEmptyResults;

    @Deprecated
    public JUnitParser() {
        this(false, false);
    }

    @Deprecated
    public JUnitParser(boolean keepLongStdio) {
        this.keepLongStdio = keepLongStdio;
        this.allowEmptyResults = false;
    }

    public JUnitParser(boolean keepLongStdio, boolean allowEmptyResults) {
        this.keepLongStdio = keepLongStdio;
        this.allowEmptyResults = allowEmptyResults;
    }

    @Override
    public String getDisplayName() {
        return Messages.JUnitParser_DisplayName();
    }

    @Override
    public String getTestResultLocationMessage() {
        return Messages.JUnitParser_TestResultLocationMessage();
    }

    @Override
    @Deprecated
    public TestResult parse(String testResultLocations, AbstractBuild build, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        return (TestResult)super.parse(testResultLocations, build, launcher, listener);
    }

    @Override
    @Deprecated
    public TestResult parseResult(String testResultLocations, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        return this.parseResult(testResultLocations, (Run)build, (PipelineTestDetails)null, workspace, launcher, listener);
    }

    @Override
    public TestResult parseResult(String testResultLocations, Run<?, ?> build, PipelineTestDetails pipelineTestDetails, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        long buildTime = build.getTimestamp().getTimeInMillis();
        long timeOnMaster = System.currentTimeMillis();
        return (TestResult)workspace.act((FilePath.FileCallable)new ParseResultCallable(testResultLocations, buildTime, timeOnMaster, this.keepLongStdio, this.allowEmptyResults, pipelineTestDetails));
    }

    private static final class ParseResultCallable
    extends MasterToSlaveFileCallable<TestResult> {
        private final long buildTime;
        private final String testResults;
        private final long nowMaster;
        private final boolean keepLongStdio;
        private final boolean allowEmptyResults;
        private final PipelineTestDetails pipelineTestDetails;

        private ParseResultCallable(String testResults, long buildTime, long nowMaster, boolean keepLongStdio, boolean allowEmptyResults, PipelineTestDetails pipelineTestDetails) {
            this.buildTime = buildTime;
            this.testResults = testResults;
            this.nowMaster = nowMaster;
            this.keepLongStdio = keepLongStdio;
            this.allowEmptyResults = allowEmptyResults;
            this.pipelineTestDetails = pipelineTestDetails;
        }

        public TestResult invoke(File ws, VirtualChannel channel) throws IOException {
            long nowSlave = System.currentTimeMillis();
            FileSet fs = Util.createFileSet((File)ws, (String)this.testResults);
            DirectoryScanner ds = fs.getDirectoryScanner();
            TestResult result = null;
            String[] files = ds.getIncludedFiles();
            if (files.length > 0) {
                result = new TestResult(this.buildTime + (nowSlave - this.nowMaster), ds, this.keepLongStdio, this.pipelineTestDetails);
                result.tally();
            } else if (this.allowEmptyResults) {
                result = new TestResult();
            } else {
                throw new AbortException(Messages.JUnitResultArchiver_NoTestReportFound());
            }
            return result;
        }
    }
}

