/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.test;

import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.TestObject;
import hudson.tasks.test.TestResult;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public abstract class AggregatedTestResultAction
extends AbstractTestResultAction {
    private int failCount;
    private int skipCount;
    private int totalCount;
    public final List<Child> children = new ArrayList<Child>();

    @Deprecated
    public AggregatedTestResultAction(AbstractBuild owner) {
        super(owner);
    }

    public AggregatedTestResultAction() {
    }

    protected void update(List<? extends AbstractTestResultAction> children) {
        this.totalCount = 0;
        this.skipCount = 0;
        this.failCount = 0;
        this.children.clear();
        for (AbstractTestResultAction abstractTestResultAction : children) {
            this.add(abstractTestResultAction);
        }
    }

    protected void add(AbstractTestResultAction child) {
        this.failCount += child.getFailCount();
        this.skipCount += child.getSkipCount();
        this.totalCount += child.getTotalCount();
        this.children.add(new Child(this.getChildName(child), child.run.number));
    }

    @Override
    public int getFailCount() {
        return this.failCount;
    }

    @Override
    public int getSkipCount() {
        return this.skipCount;
    }

    @Override
    public int getTotalCount() {
        return this.totalCount;
    }

    @Override
    public List<ChildReport> getResult() {
        return this.getChildReports();
    }

    @Override
    public List<? extends TestResult> getFailedTests() {
        ArrayList<? extends TestResult> failedTests = new ArrayList<TestResult>(this.failCount);
        for (ChildReport childReport : this.getChildReports()) {
            if (!(childReport.result instanceof TestResult)) continue;
            failedTests.addAll(((TestResult)childReport.result).getFailedTests());
        }
        return failedTests;
    }

    @Exported(inline=true)
    public List<ChildReport> getChildReports() {
        return new AbstractList<ChildReport>(){

            @Override
            public ChildReport get(int index) {
                return new ChildReport(AggregatedTestResultAction.this.resolveRun(AggregatedTestResultAction.this.children.get(index)), AggregatedTestResultAction.this.getChildReport(AggregatedTestResultAction.this.children.get(index)));
            }

            @Override
            public int size() {
                return AggregatedTestResultAction.this.children.size();
            }
        };
    }

    protected abstract String getChildName(AbstractTestResultAction var1);

    public Run<?, ?> resolveRun(Child child) {
        return this.resolveChild(child);
    }

    @Deprecated
    public AbstractBuild<?, ?> resolveChild(Child child) {
        if (Util.isOverridden(AggregatedTestResultAction.class, this.getClass(), (String)"resolveRun", (Class[])new Class[]{Child.class})) {
            Run<?, ?> r = this.resolveRun(child);
            return r instanceof AbstractBuild ? (AbstractBuild)r : null;
        }
        throw new AbstractMethodError("you must override resolveRun");
    }

    protected AbstractTestResultAction getChildReport(Child child) {
        Run<?, ?> b = this.resolveRun(child);
        if (b == null) {
            return null;
        }
        return (AbstractTestResultAction)b.getAction(AbstractTestResultAction.class);
    }

    @Override
    protected final String getDescription(TestObject object) {
        throw new AssertionError();
    }

    @Override
    protected final void setDescription(TestObject object, String description) {
        throw new AssertionError();
    }

    @ExportedBean(defaultVisibility=2)
    public static final class ChildReport {
        @Deprecated
        public final AbstractBuild<?, ?> child;
        @Exported(name="child")
        public final Run<?, ?> run;
        @Exported
        public final Object result;

        @Deprecated
        public ChildReport(AbstractBuild<?, ?> child, AbstractTestResultAction result) {
            this((Run<?, ?>)child, result);
        }

        public ChildReport(Run<?, ?> run, AbstractTestResultAction result) {
            this.child = run instanceof AbstractBuild ? (AbstractBuild)run : null;
            this.run = run;
            this.result = result != null ? result.getResult() : null;
        }
    }

    public static final class Child {
        public final String name;
        public final int build;

        public Child(String name, int build) {
            this.name = name;
            this.build = build;
        }
    }
}

