/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.junit;

import hudson.model.Run;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.ClassResult;
import hudson.tasks.junit.Messages;
import hudson.tasks.junit.TestNameTransformer;
import hudson.tasks.junit.TestResult;
import hudson.tasks.test.MetaTabulatedResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;

public final class PackageResult
extends MetaTabulatedResult
implements Comparable<PackageResult> {
    private final String packageName;
    private transient String safeName;
    private final Map<String, ClassResult> classes = new TreeMap<String, ClassResult>();
    private int passCount;
    private int failCount;
    private int skipCount;
    private final TestResult parent;
    private float duration;
    private static final long serialVersionUID = 1L;

    PackageResult(TestResult parent, String packageName) {
        this.packageName = packageName;
        this.parent = parent;
    }

    @Override
    public Run<?, ?> getRun() {
        return this.parent == null ? null : this.parent.getRun();
    }

    @Override
    public TestResult getParent() {
        return this.parent;
    }

    @Override
    @Exported(visibility=999)
    public String getName() {
        return this.packageName;
    }

    @Override
    public synchronized String getSafeName() {
        if (this.safeName != null) {
            return this.safeName;
        }
        List siblings = this.parent == null ? Collections.EMPTY_LIST : this.parent.getChildren();
        this.safeName = this.uniquifyName(siblings, PackageResult.safe(this.getName()));
        return this.safeName;
    }

    @Override
    public hudson.tasks.test.TestResult findCorrespondingResult(String id) {
        ClassResult child;
        int classNameStart;
        String myID = PackageResult.safe(this.getName());
        int base = id.indexOf(myID);
        String className = id;
        if (base > 0 && (classNameStart = base + myID.length() + 1) < id.length()) {
            className = id.substring(classNameStart);
        }
        String subId = null;
        int classNameEnd = className.indexOf(47);
        if (classNameEnd > 0) {
            subId = className.substring(classNameEnd + 1);
            if (subId.length() == 0) {
                subId = null;
            }
            className = className.substring(0, classNameEnd);
        }
        if ((child = this.getClassResult(className)) != null && subId != null) {
            return child.findCorrespondingResult(subId);
        }
        return child;
    }

    @Override
    public String getTitle() {
        return Messages.PackageResult_getTitle(this.getDisplayName());
    }

    @Override
    public String getChildTitle() {
        return Messages.PackageResult_getChildTitle();
    }

    @Override
    public float getDuration() {
        return this.duration;
    }

    @Override
    @Exported
    public int getPassCount() {
        return this.passCount;
    }

    @Override
    @Exported
    public int getFailCount() {
        return this.failCount;
    }

    @Override
    @Exported
    public int getSkipCount() {
        return this.skipCount;
    }

    @Override
    public Object getDynamic(String name, StaplerRequest req, StaplerResponse rsp) {
        ClassResult result = this.getClassResult(name);
        if (result != null) {
            return result;
        }
        return super.getDynamic(name, req, rsp);
    }

    public ClassResult getClassResult(String name) {
        return this.classes.get(name);
    }

    @Exported(name="child")
    public Collection<ClassResult> getChildren() {
        return this.classes.values();
    }

    @Override
    public boolean hasChildren() {
        int totalTests = this.passCount + this.failCount + this.skipCount;
        return totalTests != 0;
    }

    public List<CaseResult> getFailedTests() {
        ArrayList<CaseResult> r = new ArrayList<CaseResult>();
        for (ClassResult clr : this.classes.values()) {
            for (CaseResult cr : clr.getChildren()) {
                if (!cr.isFailed()) continue;
                r.add(cr);
            }
        }
        return r;
    }

    public List<CaseResult> getFailedTestsSortedByAge() {
        Collection failedTests = this.getFailedTests();
        Collections.sort(failedTests, CaseResult.BY_AGE);
        return failedTests;
    }

    public List<CaseResult> getPassedTests() {
        ArrayList<CaseResult> r = new ArrayList<CaseResult>();
        for (ClassResult clr : this.classes.values()) {
            for (CaseResult cr : clr.getChildren()) {
                if (!cr.isPassed()) continue;
                r.add(cr);
            }
        }
        Collections.sort(r, CaseResult.BY_AGE);
        return r;
    }

    public List<CaseResult> getSkippedTests() {
        ArrayList<CaseResult> r = new ArrayList<CaseResult>();
        for (ClassResult clr : this.classes.values()) {
            for (CaseResult cr : clr.getChildren()) {
                if (!cr.isSkipped()) continue;
                r.add(cr);
            }
        }
        Collections.sort(r, CaseResult.BY_AGE);
        return r;
    }

    @Override
    public boolean isPassed() {
        return this.failCount == 0 && this.skipCount == 0;
    }

    void add(CaseResult r) {
        String n = r.getSimpleName();
        String sn = PackageResult.safe(n);
        ClassResult c = this.getClassResult(sn);
        if (c == null) {
            c = new ClassResult(this, n);
            this.classes.put(sn, c);
        }
        c.add(r);
        this.duration += r.getDuration();
    }

    @Override
    public void tally() {
        this.passCount = 0;
        this.failCount = 0;
        this.skipCount = 0;
        this.duration = 0.0f;
        for (ClassResult cr : this.classes.values()) {
            cr.tally();
            this.passCount += cr.getPassCount();
            this.failCount += cr.getFailCount();
            this.skipCount += cr.getSkipCount();
            this.duration += cr.getDuration();
        }
    }

    void freeze() {
        this.skipCount = 0;
        this.failCount = 0;
        this.passCount = 0;
        for (ClassResult cr : this.classes.values()) {
            cr.freeze();
            this.passCount += cr.getPassCount();
            this.failCount += cr.getFailCount();
            this.skipCount += cr.getSkipCount();
        }
    }

    @Override
    public int compareTo(PackageResult that) {
        if (this.equals(that)) {
            return 0;
        }
        int r = this.packageName.compareTo(that.packageName);
        if (r != 0) {
            return r;
        }
        return System.identityHashCode(this) >= System.identityHashCode(that) ? 1 : -1;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public String getDisplayName() {
        return TestNameTransformer.getTransformedName(this.packageName);
    }
}

