/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.junit.pipeline;

import com.google.common.collect.ImmutableSet;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Descriptor;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.tasks.junit.JUnitTask;
import hudson.tasks.junit.Messages;
import hudson.tasks.junit.TestDataPublisher;
import hudson.tasks.junit.pipeline.JUnitResultsStepExecution;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class JUnitResultsStep
extends Step
implements JUnitTask {
    private final String testResults;
    private boolean keepLongStdio;
    private DescribableList<TestDataPublisher, Descriptor<TestDataPublisher>> testDataPublishers;
    private Double healthScaleFactor;
    private boolean allowEmptyResults;

    @DataBoundConstructor
    public JUnitResultsStep(String testResults) {
        this.testResults = testResults;
    }

    @Override
    public String getTestResults() {
        return this.testResults;
    }

    @Override
    public double getHealthScaleFactor() {
        return this.healthScaleFactor == null ? 1.0 : this.healthScaleFactor;
    }

    @DataBoundSetter
    public final void setHealthScaleFactor(double healthScaleFactor) {
        this.healthScaleFactor = Math.max(0.0, healthScaleFactor);
    }

    @Override
    @Nonnull
    public List<TestDataPublisher> getTestDataPublishers() {
        return this.testDataPublishers == null ? Collections.emptyList() : this.testDataPublishers;
    }

    @DataBoundSetter
    public final void setTestDataPublishers(@Nonnull List<TestDataPublisher> testDataPublishers) {
        this.testDataPublishers = new DescribableList(Saveable.NOOP);
        this.testDataPublishers.addAll(testDataPublishers);
    }

    @Override
    public boolean isKeepLongStdio() {
        return this.keepLongStdio;
    }

    @DataBoundSetter
    public final void setKeepLongStdio(boolean keepLongStdio) {
        this.keepLongStdio = keepLongStdio;
    }

    @Override
    public boolean isAllowEmptyResults() {
        return this.allowEmptyResults;
    }

    @DataBoundSetter
    public final void setAllowEmptyResults(boolean allowEmptyResults) {
        this.allowEmptyResults = allowEmptyResults;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new JUnitResultsStepExecution(this, context);
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "junit";
        }

        @Nonnull
        public String getDisplayName() {
            return "Archive JUnit-formatted test results";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(FilePath.class, FlowNode.class, TaskListener.class, Launcher.class);
        }

        public FormValidation doCheckHealthScaleFactor(@QueryParameter double value) {
            if (value < 1.0E-7) {
                return FormValidation.warning((String)"Test health reporting disabled");
            }
            return FormValidation.ok((String)Messages.JUnitResultArchiver_HealthScaleFactorAnalysis(1, (int)(100.0 - Math.max(0.0, Math.min(100.0, 1.0 * value))), 5, (int)(100.0 - Math.max(0.0, Math.min(100.0, 5.0 * value)))));
        }
    }
}

