/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.junit;

import edu.hm.hafner.echarts.ChartModelConfiguration;
import edu.hm.hafner.echarts.JacksonFacade;
import edu.hm.hafner.echarts.LinesChartModel;
import hudson.tasks.junit.TestResult;
import hudson.tasks.test.TestObject;
import hudson.tasks.test.TestObjectIterable;
import hudson.tasks.test.TestResultDurationChart;
import hudson.tasks.test.TestResultTrendChart;
import io.jenkins.plugins.junit.storage.TestResultImpl;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.bind.JavaScriptMethod;

@Restricted(value={NoExternalUse.class})
public class History {
    private static final JacksonFacade JACKSON_FACADE = new JacksonFacade();
    private final TestObject testObject;

    public History(TestObject testObject) {
        this.testObject = testObject;
    }

    public TestObject getTestObject() {
        return this.testObject;
    }

    public boolean historyAvailable() {
        TestResultImpl pluggableStorage;
        if (this.testObject instanceof TestResult && (pluggableStorage = ((TestResult)this.testObject).getPluggableStorage()) != null) {
            return pluggableStorage.getCountOfBuildsWithTestResults() > 1;
        }
        return this.testObject.getRun().getParent().getBuilds().size() > 1;
    }

    @JavaScriptMethod
    public String getTestResultTrend() {
        return JACKSON_FACADE.toJson((Object)this.createTestResultTrend());
    }

    private LinesChartModel createTestResultTrend() {
        TestResultImpl pluggableStorage;
        if (this.testObject instanceof TestResult && (pluggableStorage = ((TestResult)this.testObject).getPluggableStorage()) != null) {
            return new TestResultTrendChart().create(pluggableStorage.getTrendTestResultSummary());
        }
        return new TestResultTrendChart().createFromTestObject(this.createBuildHistory(this.testObject), new ChartModelConfiguration());
    }

    @JavaScriptMethod
    public String getTestDurationTrend() {
        return JACKSON_FACADE.toJson((Object)this.createTestDurationResultTrend());
    }

    private LinesChartModel createTestDurationResultTrend() {
        TestResultImpl pluggableStorage;
        if (this.testObject instanceof TestResult && (pluggableStorage = ((TestResult)this.testObject).getPluggableStorage()) != null) {
            return new TestResultDurationChart().create(pluggableStorage.getTestDurationResultSummary());
        }
        return new TestResultDurationChart().create(this.createBuildHistory(this.testObject), new ChartModelConfiguration());
    }

    private TestObjectIterable createBuildHistory(TestObject testObject) {
        return new TestObjectIterable(testObject);
    }

    public static int asInt(String s, int defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }
}

