/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.junit.pipeline;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.junit.JUnitResultArchiver;
import hudson.tasks.junit.TestResultSummary;
import hudson.tasks.junit.pipeline.JUnitResultsStep;
import hudson.tasks.test.PipelineTestDetails;
import io.jenkins.plugins.checks.steps.ChecksInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jenkinsci.plugins.workflow.actions.LabelAction;
import org.jenkinsci.plugins.workflow.actions.ThreadNameAction;
import org.jenkinsci.plugins.workflow.actions.WarningAction;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graph.StepNode;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;

public class JUnitResultsStepExecution
extends SynchronousNonBlockingStepExecution<TestResultSummary> {
    private final transient JUnitResultsStep step;
    private static final long serialVersionUID = 1L;

    public JUnitResultsStepExecution(@NonNull JUnitResultsStep step, StepContext context) {
        super(context);
        this.step = step;
    }

    protected TestResultSummary run() throws Exception {
        FilePath workspace = (FilePath)this.getContext().get(FilePath.class);
        workspace.mkdirs();
        Run run = Objects.requireNonNull((Run)this.getContext().get(Run.class));
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        Launcher launcher = (Launcher)this.getContext().get(Launcher.class);
        FlowNode node = (FlowNode)this.getContext().get(FlowNode.class);
        String nodeId = node.getId();
        List<FlowNode> enclosingBlocks = JUnitResultsStepExecution.getEnclosingStagesAndParallels(node);
        PipelineTestDetails pipelineTestDetails = new PipelineTestDetails();
        pipelineTestDetails.setNodeId(nodeId);
        pipelineTestDetails.setEnclosingBlocks(JUnitResultsStepExecution.getEnclosingBlockIds(enclosingBlocks));
        pipelineTestDetails.setEnclosingBlockNames(JUnitResultsStepExecution.getEnclosingBlockNames(enclosingBlocks));
        try {
            int testFailures;
            TestResultSummary summary;
            if (Util.fixEmpty((String)this.step.getChecksName()) == null) {
                Optional.ofNullable((ChecksInfo)this.getContext().get(ChecksInfo.class)).map(ChecksInfo::getName).ifPresent(this.step::setChecksName);
            }
            if ((summary = JUnitResultArchiver.parseAndSummarize(this.step, pipelineTestDetails, run, workspace, launcher, listener)).getFailCount() > 0 && (testFailures = summary.getFailCount()) > 0) {
                node.addOrReplaceAction((Action)new WarningAction(Result.UNSTABLE).withMessage(testFailures + " tests failed"));
                if (!this.step.isSkipMarkingBuildUnstable()) {
                    run.setResult(Result.UNSTABLE);
                }
            }
            return summary;
        }
        catch (Exception e) {
            assert (listener != null);
            listener.getLogger().println(e.getMessage());
            throw e;
        }
    }

    @NonNull
    public static List<FlowNode> getEnclosingStagesAndParallels(FlowNode node) {
        ArrayList<FlowNode> enclosingBlocks = new ArrayList<FlowNode>();
        for (FlowNode enclosing : node.getEnclosingBlocks()) {
            if (enclosing == null || enclosing.getAction(LabelAction.class) == null || !JUnitResultsStepExecution.isStageNode(enclosing) && enclosing.getAction(ThreadNameAction.class) == null) continue;
            enclosingBlocks.add(enclosing);
        }
        return enclosingBlocks;
    }

    private static boolean isStageNode(@NonNull FlowNode node) {
        if (node instanceof StepNode) {
            StepDescriptor d = ((StepNode)node).getDescriptor();
            return d != null && d.getFunctionName().equals("stage");
        }
        return false;
    }

    @NonNull
    public static List<String> getEnclosingBlockIds(@NonNull List<FlowNode> nodes) {
        ArrayList<String> ids = new ArrayList<String>();
        for (FlowNode n : nodes) {
            ids.add(n.getId());
        }
        return ids;
    }

    @NonNull
    public static List<String> getEnclosingBlockNames(@NonNull List<FlowNode> nodes) {
        ArrayList<String> names = new ArrayList<String>();
        for (FlowNode n : nodes) {
            ThreadNameAction threadNameAction = (ThreadNameAction)n.getPersistentAction(ThreadNameAction.class);
            LabelAction labelAction = (LabelAction)n.getPersistentAction(LabelAction.class);
            if (threadNameAction != null) {
                if (!names.isEmpty() && threadNameAction.getThreadName().equals(names.get(names.size() - 1))) continue;
                names.add(threadNameAction.getThreadName());
                continue;
            }
            if (labelAction == null) continue;
            names.add(labelAction.getDisplayName());
        }
        return names;
    }
}

