/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.test;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Functions;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Api;
import hudson.model.Item;
import hudson.model.Run;
import hudson.tasks.junit.History;
import hudson.tasks.junit.TestAction;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.TestResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.interceptor.RequirePOST;

@ExportedBean
@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"}, justification="Accepted")
public abstract class TestObject
extends hudson.tasks.junit.TestObject {
    private static final Logger LOGGER = Logger.getLogger(TestObject.class.getName());
    private volatile transient String id;
    private static final Map<String, Map<TestObject, Void>> UNIQUIFIED_NAMES = new HashMap<String, Map<TestObject, Void>>();
    private static final long serialVersionUID = 1L;

    @Override
    public abstract TestObject getParent();

    @Override
    public final String getId() {
        if (this.id == null) {
            String parentId;
            StringBuilder buf = new StringBuilder();
            buf.append(this.getSafeName());
            TestObject parent = this.getParent();
            if (parent != null && (parentId = parent.getId()) != null && parentId.length() > 0) {
                buf.insert(0, '/');
                buf.insert(0, parent.getId());
            }
            this.id = buf.toString();
        }
        return this.id;
    }

    @Override
    public String getUrl() {
        return this.getRun().getUrl() + this.getTestResultAction().getUrlName() + "/" + this.getId();
    }

    public String getFullDisplayName() {
        return this.getDisplayName();
    }

    @Override
    public hudson.tasks.junit.TestResult getTestResult() {
        TestObject parent = this.getParent();
        return parent == null ? null : this.getParent().getTestResult();
    }

    public TestResult getTopLevelTestResult() {
        TestObject parent = this.getParent();
        return parent == null ? null : this.getParent().getTopLevelTestResult();
    }

    public String getRelativePathFrom(TestObject it) {
        if (it == this) {
            return ".";
        }
        StringBuilder buf = new StringBuilder();
        TestObject next = this;
        TestObject cur = this;
        while (next != null && it != next) {
            cur = next;
            buf.insert(0, '/');
            buf.insert(0, cur.getSafeName());
            next = cur.getParent();
        }
        if (it == next) {
            return buf.toString();
        }
        AbstractTestResultAction action = this.getTestResultAction();
        if (action == null) {
            LOGGER.warning("trying to get relative path, but we can't determine the action that owns this result.");
            return "";
        }
        buf.insert(0, '/');
        buf.insert(0, action.getUrlName());
        Run<?, ?> myBuild = cur.getRun();
        if (myBuild == null) {
            LOGGER.warning("trying to get relative path, but we can't determine the build that owns this result.");
            return "";
        }
        buf.insert(0, '/');
        buf.insert(0, myBuild.getUrl());
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req != null && myBuild instanceof Item) {
            buf.insert(0, '/');
            Item myBuildAsItem = (Item)myBuild;
            buf.insert(0, Functions.getRelativeLinkTo((Item)myBuildAsItem));
        } else {
            LOGGER.fine("trying to get relative path, but it is not my ancestor, and we are not in a stapler request. Trying absolute jenkins url...");
            String jenkinsUrl = Jenkins.get().getRootUrl();
            if (jenkinsUrl == null || jenkinsUrl.length() == 0) {
                LOGGER.warning("Can't find anything like a decent hudson url. Punting, returning empty string.");
                return "";
            }
            if (!jenkinsUrl.endsWith("/")) {
                buf.insert(0, '/');
            }
            buf.insert(0, jenkinsUrl);
        }
        LOGGER.log(Level.FINE, "Here is our relative path: {0}", buf);
        return buf.toString();
    }

    @Override
    public AbstractTestResultAction getTestResultAction() {
        Run<?, ?> owner = this.getRun();
        if (owner != null) {
            return (AbstractTestResultAction)owner.getAction(AbstractTestResultAction.class);
        }
        Run run = (Run)Stapler.getCurrentRequest().findAncestorObject(Run.class);
        if (run != null) {
            return (AbstractTestResultAction)run.getAction(AbstractTestResultAction.class);
        }
        LOGGER.warning("owner is null when trying to getTestResultAction.");
        return null;
    }

    @Override
    @Exported(visibility=3)
    public List<TestAction> getTestActions() {
        AbstractTestResultAction atra = this.getTestResultAction();
        if (atra != null && atra instanceof TestResultAction) {
            TestResultAction tra = (TestResultAction)atra;
            return tra.getActions(this);
        }
        return new ArrayList<TestAction>();
    }

    @Override
    public <T> T getTestAction(Class<T> klazz) {
        for (TestAction action : this.getTestActions()) {
            if (!klazz.isAssignableFrom(action.getClass())) continue;
            return klazz.cast(action);
        }
        return null;
    }

    @Override
    public abstract TestResult getPreviousResult();

    @Override
    @Deprecated
    public TestResult getResultInBuild(AbstractBuild<?, ?> build) {
        return (TestResult)super.getResultInBuild(build);
    }

    @Override
    public TestResult getResultInRun(Run<?, ?> run) {
        return (TestResult)super.getResultInRun(run);
    }

    public abstract TestResult findCorrespondingResult(String var1);

    @Override
    public abstract float getDuration();

    @Override
    public String getDurationString() {
        return Util.getTimeSpanString((long)((long)(this.getDuration() * 1000.0f)));
    }

    @Override
    public String getDescription() {
        AbstractTestResultAction action = this.getTestResultAction();
        if (action != null) {
            return action.getDescription(this);
        }
        return "";
    }

    @Override
    public void setDescription(String description) {
        AbstractTestResultAction action = this.getTestResultAction();
        if (action != null) {
            action.setDescription(this, description);
        }
    }

    @Override
    public Api getApi() {
        return new Api((Object)this);
    }

    @Override
    public String getName() {
        return "";
    }

    public String getFullName() {
        StringBuilder sb = new StringBuilder(this.getName());
        if (this.getParent() != null) {
            sb.insert(0, " : ");
            sb.insert(0, this.getParent().getFullName());
        }
        return sb.toString();
    }

    @Override
    public String getSafeName() {
        return TestObject.safe(this.getName());
    }

    @Override
    public String getSearchUrl() {
        return this.getSafeName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String uniquifyName(Collection<? extends TestObject> siblings, String base) {
        Map<String, Map<TestObject, Void>> map = UNIQUIFIED_NAMES;
        synchronized (map) {
            String uniquified = base;
            Map<TestObject, Void> taken = UNIQUIFIED_NAMES.get(base);
            if (taken == null) {
                taken = new WeakHashMap<TestObject, Void>();
                UNIQUIFIED_NAMES.put(base, taken);
            } else {
                HashSet<TestObject> similars = new HashSet<TestObject>(taken.keySet());
                similars.retainAll(new HashSet<TestObject>(siblings));
                if (!similars.isEmpty()) {
                    uniquified = base + '_' + (similars.size() + 1);
                }
            }
            taken.put(this, null);
            return uniquified;
        }
    }

    public static String safe(String s) {
        if (StringUtils.isEmpty((String)s)) {
            return "(empty)";
        }
        return s.replace('/', '_').replace('\\', '_').replace(':', '_').replace('?', '_').replace('#', '_').replace('%', '_').replace('<', '_').replace('>', '_');
    }

    @Override
    public abstract int getPassCount();

    @Override
    public abstract int getFailCount();

    @Override
    public abstract int getSkipCount();

    @Override
    public int getTotalCount() {
        return this.getPassCount() + this.getFailCount() + this.getSkipCount();
    }

    @Override
    public History getHistory() {
        return new History(this);
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        for (Action action : this.getTestActions()) {
            String urlName;
            if (action == null || (urlName = action.getUrlName()) == null || !urlName.equals(token)) continue;
            return action;
        }
        return null;
    }

    @RequirePOST
    public synchronized HttpResponse doSubmitDescription(@QueryParameter String description) throws IOException, ServletException {
        Run<?, ?> run = this.getRun();
        if (run == null) {
            LOGGER.severe("getRun() is null, can't save description.");
        } else {
            run.checkPermission(Run.UPDATE);
            this.setDescription(description);
            run.save();
        }
        return new HttpRedirect(".");
    }
}

