/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.test;

import edu.hm.hafner.echarts.ChartModelConfiguration;
import edu.hm.hafner.echarts.LineSeries;
import edu.hm.hafner.echarts.LinesChartModel;
import edu.hm.hafner.echarts.LinesDataSet;
import edu.hm.hafner.echarts.Palette;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.tasks.junit.TrendTestResultSummary;
import hudson.tasks.test.TestObjectTrendSeriesBuilder;
import hudson.tasks.test.TestResultTrendSeriesBuilder;
import java.util.List;

public class TestResultTrendChart {
    public LinesChartModel create(List<TrendTestResultSummary> results) {
        return this.create(results, PassedColor.BLUE);
    }

    public LinesChartModel create(List<TrendTestResultSummary> results, PassedColor passedColor) {
        LinesDataSet dataset = new LinesDataSet();
        results.forEach(result -> dataset.add(result.getDisplayName(), result.toMap(), result.getBuildNumber()));
        return this.getLinesChartModel(dataset, passedColor);
    }

    public LinesChartModel create(@NonNull Iterable results, ChartModelConfiguration configuration) {
        return this.create(results, configuration, PassedColor.GREEN);
    }

    public LinesChartModel create(@NonNull Iterable results, ChartModelConfiguration configuration, PassedColor passedColor) {
        TestResultTrendSeriesBuilder builder = new TestResultTrendSeriesBuilder();
        LinesDataSet dataSet = builder.createDataSet(configuration, results);
        return this.getLinesChartModel(dataSet, passedColor);
    }

    public LinesChartModel createFromTestObject(Iterable results, ChartModelConfiguration configuration) {
        return this.createFromTestObject(results, configuration, PassedColor.GREEN);
    }

    public LinesChartModel createFromTestObject(Iterable results, ChartModelConfiguration configuration, PassedColor passedColor) {
        TestObjectTrendSeriesBuilder builder = new TestObjectTrendSeriesBuilder();
        LinesDataSet dataSet = builder.createDataSet(configuration, results);
        return this.getLinesChartModel(dataSet, passedColor);
    }

    private LinesChartModel getLinesChartModel(LinesDataSet dataSet, PassedColor passedColor) {
        LinesChartModel model = new LinesChartModel(dataSet);
        LineSeries passed = new LineSeries("Passed", passedColor == PassedColor.BLUE ? Palette.BLUE.getNormal() : Palette.GREEN.getNormal(), LineSeries.StackedMode.STACKED, LineSeries.FilledMode.FILLED);
        passed.addAll(dataSet.getSeries("passed"));
        model.addSeries(new LineSeries[]{passed});
        LineSeries skipped = new LineSeries("Skipped", Palette.GRAY.getNormal(), LineSeries.StackedMode.STACKED, LineSeries.FilledMode.FILLED);
        skipped.addAll(dataSet.getSeries("skipped"));
        model.addSeries(new LineSeries[]{skipped});
        LineSeries failed = new LineSeries("Failed", Palette.RED.getNormal(), LineSeries.StackedMode.STACKED, LineSeries.FilledMode.FILLED);
        failed.addAll(dataSet.getSeries("failed"));
        model.addSeries(new LineSeries[]{failed});
        return model;
    }

    static enum PassedColor {
        GREEN,
        BLUE;

    }
}

