// CHECKSTYLE:OFF

package hudson.tasks.junit;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code JUnitResultArchiver.Recording}: {@code Recording test
     * results}.
     * 
     * @return
     *     {@code Recording test results}
     */
    public static String JUnitResultArchiver_Recording() {
        return holder.format("JUnitResultArchiver.Recording");
    }

    /**
     * Key {@code JUnitResultArchiver.Recording}: {@code Recording test
     * results}.
     * 
     * @return
     *     {@code Recording test results}
     */
    public static Localizable _JUnitResultArchiver_Recording() {
        return new Localizable(holder, "JUnitResultArchiver.Recording");
    }

    /**
     * Key {@code JUnitParser.DisplayName}: {@code JUnit Parser}.
     * 
     * @return
     *     {@code JUnit Parser}
     */
    public static String JUnitParser_DisplayName() {
        return holder.format("JUnitParser.DisplayName");
    }

    /**
     * Key {@code JUnitParser.DisplayName}: {@code JUnit Parser}.
     * 
     * @return
     *     {@code JUnit Parser}
     */
    public static Localizable _JUnitParser_DisplayName() {
        return new Localizable(holder, "JUnitParser.DisplayName");
    }

    /**
     * Key {@code JUnitResultArchiver.HealthScaleFactorAnalysis}: {@code {0}%
     * failing tests scores as {1}% health. {2}% failing tests scores as {3}%
     * health}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0}% failing tests scores as {1}% health. {2}% failing tests
     *     scores as {3}% health}
     */
    public static String JUnitResultArchiver_HealthScaleFactorAnalysis(Object arg0, Object arg1, Object arg2, Object arg3) {
        return holder.format("JUnitResultArchiver.HealthScaleFactorAnalysis", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code JUnitResultArchiver.HealthScaleFactorAnalysis}: {@code {0}%
     * failing tests scores as {1}% health. {2}% failing tests scores as {3}%
     * health}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0}% failing tests scores as {1}% health. {2}% failing tests
     *     scores as {3}% health}
     */
    public static Localizable _JUnitResultArchiver_HealthScaleFactorAnalysis(Object arg0, Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "JUnitResultArchiver.HealthScaleFactorAnalysis", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code JUnitResultArchiver.ResultIsEmpty}: {@code None of the test
     * reports contained any result}.
     * 
     * @return
     *     {@code None of the test reports contained any result}
     */
    public static String JUnitResultArchiver_ResultIsEmpty() {
        return holder.format("JUnitResultArchiver.ResultIsEmpty");
    }

    /**
     * Key {@code JUnitResultArchiver.ResultIsEmpty}: {@code None of the test
     * reports contained any result}.
     * 
     * @return
     *     {@code None of the test reports contained any result}
     */
    public static Localizable _JUnitResultArchiver_ResultIsEmpty() {
        return new Localizable(holder, "JUnitResultArchiver.ResultIsEmpty");
    }

    /**
     * Key {@code TestResult.getDisplayName}: {@code Test Results}.
     * 
     * @return
     *     {@code Test Results}
     */
    public static String TestResult_getDisplayName() {
        return holder.format("TestResult.getDisplayName");
    }

    /**
     * Key {@code TestResult.getDisplayName}: {@code Test Results}.
     * 
     * @return
     *     {@code Test Results}
     */
    public static Localizable _TestResult_getDisplayName() {
        return new Localizable(holder, "TestResult.getDisplayName");
    }

    /**
     * Key {@code CaseResult.Status.Fixed}: {@code Fixed}.
     * 
     * @return
     *     {@code Fixed}
     */
    public static String CaseResult_Status_Fixed() {
        return holder.format("CaseResult.Status.Fixed");
    }

    /**
     * Key {@code CaseResult.Status.Fixed}: {@code Fixed}.
     * 
     * @return
     *     {@code Fixed}
     */
    public static Localizable _CaseResult_Status_Fixed() {
        return new Localizable(holder, "CaseResult.Status.Fixed");
    }

    /**
     * Key {@code TestResult.getTitle}: {@code Test Result}.
     * 
     * @return
     *     {@code Test Result}
     */
    public static String TestResult_getTitle() {
        return holder.format("TestResult.getTitle");
    }

    /**
     * Key {@code TestResult.getTitle}: {@code Test Result}.
     * 
     * @return
     *     {@code Test Result}
     */
    public static Localizable _TestResult_getTitle() {
        return new Localizable(holder, "TestResult.getTitle");
    }

    /**
     * Key {@code TestResult.getChildTitle}: {@code Package}.
     * 
     * @return
     *     {@code Package}
     */
    public static String TestResult_getChildTitle() {
        return holder.format("TestResult.getChildTitle");
    }

    /**
     * Key {@code TestResult.getChildTitle}: {@code Package}.
     * 
     * @return
     *     {@code Package}
     */
    public static Localizable _TestResult_getChildTitle() {
        return new Localizable(holder, "TestResult.getChildTitle");
    }

    /**
     * Key {@code CaseResult.Status.Passed}: {@code Passed}.
     * 
     * @return
     *     {@code Passed}
     */
    public static String CaseResult_Status_Passed() {
        return holder.format("CaseResult.Status.Passed");
    }

    /**
     * Key {@code CaseResult.Status.Passed}: {@code Passed}.
     * 
     * @return
     *     {@code Passed}
     */
    public static Localizable _CaseResult_Status_Passed() {
        return new Localizable(holder, "CaseResult.Status.Passed");
    }

    /**
     * Key {@code CaseResult.Status.Skipped}: {@code Skipped}.
     * 
     * @return
     *     {@code Skipped}
     */
    public static String CaseResult_Status_Skipped() {
        return holder.format("CaseResult.Status.Skipped");
    }

    /**
     * Key {@code CaseResult.Status.Skipped}: {@code Skipped}.
     * 
     * @return
     *     {@code Skipped}
     */
    public static Localizable _CaseResult_Status_Skipped() {
        return new Localizable(holder, "CaseResult.Status.Skipped");
    }

    /**
     * Key {@code PackageResult.getTitle}: {@code Test Result : {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Test Result : {0}}
     */
    public static String PackageResult_getTitle(Object arg0) {
        return holder.format("PackageResult.getTitle", arg0);
    }

    /**
     * Key {@code PackageResult.getTitle}: {@code Test Result : {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Test Result : {0}}
     */
    public static Localizable _PackageResult_getTitle(Object arg0) {
        return new Localizable(holder, "PackageResult.getTitle", arg0);
    }

    /**
     * Key {@code ClassResult.getTitle}: {@code Test Result : {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Test Result : {0}}
     */
    public static String ClassResult_getTitle(Object arg0) {
        return holder.format("ClassResult.getTitle", arg0);
    }

    /**
     * Key {@code ClassResult.getTitle}: {@code Test Result : {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Test Result : {0}}
     */
    public static Localizable _ClassResult_getTitle(Object arg0) {
        return new Localizable(holder, "ClassResult.getTitle", arg0);
    }

    /**
     * Key {@code CaseResult.Status.Failed}: {@code Failed}.
     * 
     * @return
     *     {@code Failed}
     */
    public static String CaseResult_Status_Failed() {
        return holder.format("CaseResult.Status.Failed");
    }

    /**
     * Key {@code CaseResult.Status.Failed}: {@code Failed}.
     * 
     * @return
     *     {@code Failed}
     */
    public static Localizable _CaseResult_Status_Failed() {
        return new Localizable(holder, "CaseResult.Status.Failed");
    }

    /**
     * Key {@code CaseResult.Status.Regression}: {@code Regression}.
     * 
     * @return
     *     {@code Regression}
     */
    public static String CaseResult_Status_Regression() {
        return holder.format("CaseResult.Status.Regression");
    }

    /**
     * Key {@code CaseResult.Status.Regression}: {@code Regression}.
     * 
     * @return
     *     {@code Regression}
     */
    public static Localizable _CaseResult_Status_Regression() {
        return new Localizable(holder, "CaseResult.Status.Regression");
    }

    /**
     * Key {@code PackageResult.getChildTitle}: {@code Class}.
     * 
     * @return
     *     {@code Class}
     */
    public static String PackageResult_getChildTitle() {
        return holder.format("PackageResult.getChildTitle");
    }

    /**
     * Key {@code PackageResult.getChildTitle}: {@code Class}.
     * 
     * @return
     *     {@code Class}
     */
    public static Localizable _PackageResult_getChildTitle() {
        return new Localizable(holder, "PackageResult.getChildTitle");
    }

    /**
     * Key {@code JUnitResultArchiver.NoTestReportFound}: {@code No test
     * report files were found. Configuration error?}.
     * 
     * @return
     *     {@code No test report files were found. Configuration error?}
     */
    public static String JUnitResultArchiver_NoTestReportFound() {
        return holder.format("JUnitResultArchiver.NoTestReportFound");
    }

    /**
     * Key {@code JUnitResultArchiver.NoTestReportFound}: {@code No test
     * report files were found. Configuration error?}.
     * 
     * @return
     *     {@code No test report files were found. Configuration error?}
     */
    public static Localizable _JUnitResultArchiver_NoTestReportFound() {
        return new Localizable(holder, "JUnitResultArchiver.NoTestReportFound");
    }

    /**
     * Key {@code JUnitResultArchiver.DisplayName}: {@code Publish JUnit test
     * result report}.
     * 
     * @return
     *     {@code Publish JUnit test result report}
     */
    public static String JUnitResultArchiver_DisplayName() {
        return holder.format("JUnitResultArchiver.DisplayName");
    }

    /**
     * Key {@code JUnitResultArchiver.DisplayName}: {@code Publish JUnit test
     * result report}.
     * 
     * @return
     *     {@code Publish JUnit test result report}
     */
    public static Localizable _JUnitResultArchiver_DisplayName() {
        return new Localizable(holder, "JUnitResultArchiver.DisplayName");
    }

    /**
     * Key {@code JUnitParser.TestResultLocationMessage}: {@code JUnit xml
     * files:}.
     * 
     * @return
     *     {@code JUnit xml files:}
     */
    public static String JUnitParser_TestResultLocationMessage() {
        return holder.format("JUnitParser.TestResultLocationMessage");
    }

    /**
     * Key {@code JUnitParser.TestResultLocationMessage}: {@code JUnit xml
     * files:}.
     * 
     * @return
     *     {@code JUnit xml files:}
     */
    public static Localizable _JUnitParser_TestResultLocationMessage() {
        return new Localizable(holder, "JUnitParser.TestResultLocationMessage");
    }

}
