// CHECKSTYLE:OFF

package hudson.tasks.test;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code AbstractTestResultAction.fail}: {@code {0}: {1}
     * {1,choice,0#failures|1#failure|1<failures}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, a number.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0}: {1} {1,choice,0#failures|1#failure|1<failures}}
     */
    public static String AbstractTestResultAction_fail(Object arg0, Object arg1) {
        return holder.format("AbstractTestResultAction.fail", arg0, arg1);
    }

    /**
     * Key {@code AbstractTestResultAction.fail}: {@code {0}: {1}
     * {1,choice,0#failures|1#failure|1<failures}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, a number.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0}: {1} {1,choice,0#failures|1#failure|1<failures}}
     */
    public static Localizable _AbstractTestResultAction_fail(Object arg0, Object arg1) {
        return new Localizable(holder, "AbstractTestResultAction.fail", arg0, arg1);
    }

    /**
     * Key {@code BuildTrigger.NoSuchProject}: {@code No such project ‘{0}’.
     * Did you mean ‘{1}’?}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such project ‘{0}’. Did you mean ‘{1}’?}
     */
    public static String BuildTrigger_NoSuchProject(Object arg0, Object arg1) {
        return holder.format("BuildTrigger.NoSuchProject", arg0, arg1);
    }

    /**
     * Key {@code BuildTrigger.NoSuchProject}: {@code No such project ‘{0}’.
     * Did you mean ‘{1}’?}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such project ‘{0}’. Did you mean ‘{1}’?}
     */
    public static Localizable _BuildTrigger_NoSuchProject(Object arg0, Object arg1) {
        return new Localizable(holder, "BuildTrigger.NoSuchProject", arg0, arg1);
    }

    /**
     * Key {@code Run.Summary.TestFailures}: {@code {0} {0,choice,0#test
     * failures|1#test failure|1<test failures}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, a number.
     * @return
     *     {@code {0} {0,choice,0#test failures|1#test failure|1<test failures}}
     */
    public static String Run_Summary_TestFailures(Object arg0) {
        return holder.format("Run.Summary.TestFailures", arg0);
    }

    /**
     * Key {@code Run.Summary.TestFailures}: {@code {0} {0,choice,0#test
     * failures|1#test failure|1<test failures}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, a number.
     * @return
     *     {@code {0} {0,choice,0#test failures|1#test failure|1<test failures}}
     */
    public static Localizable _Run_Summary_TestFailures(Object arg0) {
        return new Localizable(holder, "Run.Summary.TestFailures", arg0);
    }

    /**
     * Key {@code AbstractTestResultAction.getDisplayName}: {@code Test
     * Result}.
     * 
     * @return
     *     {@code Test Result}
     */
    public static String AbstractTestResultAction_getDisplayName() {
        return holder.format("AbstractTestResultAction.getDisplayName");
    }

    /**
     * Key {@code AbstractTestResultAction.getDisplayName}: {@code Test
     * Result}.
     * 
     * @return
     *     {@code Test Result}
     */
    public static Localizable _AbstractTestResultAction_getDisplayName() {
        return new Localizable(holder, "AbstractTestResultAction.getDisplayName");
    }

    /**
     * Key {@code AbstractTestResultAction.test}: {@code {0}: {1}
     * {1,choice,0#tests|1#test|1<tests}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, a number.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0}: {1} {1,choice,0#tests|1#test|1<tests}}
     */
    public static String AbstractTestResultAction_test(Object arg0, Object arg1) {
        return holder.format("AbstractTestResultAction.test", arg0, arg1);
    }

    /**
     * Key {@code AbstractTestResultAction.test}: {@code {0}: {1}
     * {1,choice,0#tests|1#test|1<tests}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, a number.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0}: {1} {1,choice,0#tests|1#test|1<tests}}
     */
    public static Localizable _AbstractTestResultAction_test(Object arg0, Object arg1) {
        return new Localizable(holder, "AbstractTestResultAction.test", arg0, arg1);
    }

    /**
     * Key {@code Run.Summary.MoreTestsFailing}: {@code {0} more
     * {0,choice,0#tests are|1#test is|1<tests are} failing (total {1})}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, a number.
     * @return
     *     {@code {0} more {0,choice,0#tests are|1#test is|1<tests are} failing
     *     (total {1})}
     */
    public static String Run_Summary_MoreTestsFailing(Object arg0, Object arg1) {
        return holder.format("Run.Summary.MoreTestsFailing", arg0, arg1);
    }

    /**
     * Key {@code Run.Summary.MoreTestsFailing}: {@code {0} more
     * {0,choice,0#tests are|1#test is|1<tests are} failing (total {1})}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, a number.
     * @return
     *     {@code {0} more {0,choice,0#tests are|1#test is|1<tests are} failing
     *     (total {1})}
     */
    public static Localizable _Run_Summary_MoreTestsFailing(Object arg0, Object arg1) {
        return new Localizable(holder, "Run.Summary.MoreTestsFailing", arg0, arg1);
    }

    /**
     * Key {@code AggregatedTestResultPublisher.DisplayName}: {@code
     * Aggregate downstream test results}.
     * 
     * @return
     *     {@code Aggregate downstream test results}
     */
    public static String AggregatedTestResultPublisher_DisplayName() {
        return holder.format("AggregatedTestResultPublisher.DisplayName");
    }

    /**
     * Key {@code AggregatedTestResultPublisher.DisplayName}: {@code
     * Aggregate downstream test results}.
     * 
     * @return
     *     {@code Aggregate downstream test results}
     */
    public static Localizable _AggregatedTestResultPublisher_DisplayName() {
        return new Localizable(holder, "AggregatedTestResultPublisher.DisplayName");
    }

    /**
     * Key {@code Run.Summary.TestsStartedToFail}: {@code {0}
     * {0,choice,0#tests|1#test|1<tests}  started to fail}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, a number.
     * @return
     *     {@code {0} {0,choice,0#tests|1#test|1<tests}  started to fail}
     */
    public static String Run_Summary_TestsStartedToFail(Object arg0) {
        return holder.format("Run.Summary.TestsStartedToFail", arg0);
    }

    /**
     * Key {@code Run.Summary.TestsStartedToFail}: {@code {0}
     * {0,choice,0#tests|1#test|1<tests}  started to fail}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, a number.
     * @return
     *     {@code {0} {0,choice,0#tests|1#test|1<tests}  started to fail}
     */
    public static Localizable _Run_Summary_TestsStartedToFail(Object arg0) {
        return new Localizable(holder, "Run.Summary.TestsStartedToFail", arg0);
    }

    /**
     * Key {@code Run.Summary.TestsStillFailing}: {@code {0}
     * {0,choice,0#tests are|1#test is|1<tests are} still failing}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, a number.
     * @return
     *     {@code {0} {0,choice,0#tests are|1#test is|1<tests are} still failing}
     */
    public static String Run_Summary_TestsStillFailing(Object arg0) {
        return holder.format("Run.Summary.TestsStillFailing", arg0);
    }

    /**
     * Key {@code Run.Summary.TestsStillFailing}: {@code {0}
     * {0,choice,0#tests are|1#test is|1<tests are} still failing}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, a number.
     * @return
     *     {@code {0} {0,choice,0#tests are|1#test is|1<tests are} still failing}
     */
    public static Localizable _Run_Summary_TestsStillFailing(Object arg0) {
        return new Localizable(holder, "Run.Summary.TestsStillFailing", arg0);
    }

    /**
     * Key {@code AbstractTestResultAction.skip}: {@code {0}: {1}
     * {1,choice,0#skips|1#skip|1<skips}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, a number.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0}: {1} {1,choice,0#skips|1#skip|1<skips}}
     */
    public static String AbstractTestResultAction_skip(Object arg0, Object arg1) {
        return holder.format("AbstractTestResultAction.skip", arg0, arg1);
    }

    /**
     * Key {@code AbstractTestResultAction.skip}: {@code {0}: {1}
     * {1,choice,0#skips|1#skip|1<skips}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, a number.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0}: {1} {1,choice,0#skips|1#skip|1<skips}}
     */
    public static Localizable _AbstractTestResultAction_skip(Object arg0, Object arg1) {
        return new Localizable(holder, "AbstractTestResultAction.skip", arg0, arg1);
    }

    /**
     * Key {@code Run.Summary.LessTestsFailing}: {@code {0} less
     * {0,choice,0#tests are|1#test is|1<tests are} failing (total {1})}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, a number.
     * @return
     *     {@code {0} less {0,choice,0#tests are|1#test is|1<tests are} failing
     *     (total {1})}
     */
    public static String Run_Summary_LessTestsFailing(Object arg0, Object arg1) {
        return holder.format("Run.Summary.LessTestsFailing", arg0, arg1);
    }

    /**
     * Key {@code Run.Summary.LessTestsFailing}: {@code {0} less
     * {0,choice,0#tests are|1#test is|1<tests are} failing (total {1})}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, a number.
     * @return
     *     {@code {0} less {0,choice,0#tests are|1#test is|1<tests are} failing
     *     (total {1})}
     */
    public static Localizable _Run_Summary_LessTestsFailing(Object arg0, Object arg1) {
        return new Localizable(holder, "Run.Summary.LessTestsFailing", arg0, arg1);
    }

    /**
     * Key {@code AbstractTestResultAction.TestsDescription}: {@code {0}: {1}
     * {1,choice,0#tests|1#test|1<tests} failing out of a total of {2}
     * {2,choice,1#test|1<tests}.}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, a number.
     * @param arg1
     *      2nd format parameter, {@code {1}}, a number.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0}: {1} {1,choice,0#tests|1#test|1<tests} failing out of a
     *     total of {2} {2,choice,1#test|1<tests}.}
     */
    public static String AbstractTestResultAction_TestsDescription(Object arg0, Object arg1, Object arg2) {
        return holder.format("AbstractTestResultAction.TestsDescription", arg0, arg1, arg2);
    }

    /**
     * Key {@code AbstractTestResultAction.TestsDescription}: {@code {0}: {1}
     * {1,choice,0#tests|1#test|1<tests} failing out of a total of {2}
     * {2,choice,1#test|1<tests}.}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, a number.
     * @param arg1
     *      2nd format parameter, {@code {1}}, a number.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0}: {1} {1,choice,0#tests|1#test|1<tests} failing out of a
     *     total of {2} {2,choice,1#test|1<tests}.}
     */
    public static Localizable _AbstractTestResultAction_TestsDescription(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "AbstractTestResultAction.TestsDescription", arg0, arg1, arg2);
    }

    /**
     * Key {@code AbstractTestResultAction.zeroTestDescription}: {@code {0}:
     *  0 tests in total.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0}: 0 tests in total.}
     */
    public static String AbstractTestResultAction_zeroTestDescription(Object arg0) {
        return holder.format("AbstractTestResultAction.zeroTestDescription", arg0);
    }

    /**
     * Key {@code AbstractTestResultAction.zeroTestDescription}: {@code {0}:
     *  0 tests in total.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0}: 0 tests in total.}
     */
    public static Localizable _AbstractTestResultAction_zeroTestDescription(Object arg0) {
        return new Localizable(holder, "AbstractTestResultAction.zeroTestDescription", arg0);
    }

    /**
     * Key {@code AggregatedTestResultPublisher.Title}: {@code Aggregated
     * Test Result}.
     * 
     * @return
     *     {@code Aggregated Test Result}
     */
    public static String AggregatedTestResultPublisher_Title() {
        return holder.format("AggregatedTestResultPublisher.Title");
    }

    /**
     * Key {@code AggregatedTestResultPublisher.Title}: {@code Aggregated
     * Test Result}.
     * 
     * @return
     *     {@code Aggregated Test Result}
     */
    public static Localizable _AggregatedTestResultPublisher_Title() {
        return new Localizable(holder, "AggregatedTestResultPublisher.Title");
    }

}
