/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.logfilesizechecker;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.logfilesizechecker.Messages;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.triggers.SafeTimerTask;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import jenkins.tasks.SimpleBuildWrapper;
import jenkins.util.Timer;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class LogfilesizecheckerWrapper
extends SimpleBuildWrapper
implements Serializable {
    public boolean setOwn;
    public int maxLogSize;
    public boolean failBuild;
    private static final long DELAY = 1L;
    private static final long MB = 0x100000L;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public LogfilesizecheckerWrapper(int maxLogSize, boolean failBuild, boolean setOwn) {
        this.maxLogSize = maxLogSize;
        this.failBuild = failBuild;
        this.setOwn = setOwn;
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
        int allowedLogSize = this.setOwn ? this.maxLogSize : DESCRIPTOR.getDefaultLogSize();
        if (allowedLogSize > 0) {
            LogSizeTimerTask logSizeTimerTask = new LogSizeTimerTask(build, listener, allowedLogSize, this.failBuild);
            Timer.get().scheduleAtFixedRate((Runnable)((Object)logSizeTimerTask), 1L, DESCRIPTOR.getCheckPeriod(), TimeUnit.SECONDS);
            context.setDisposer((SimpleBuildWrapper.Disposer)new LogSizeTimerTaskDisposer(logSizeTimerTask));
        }
    }

    public Descriptor<BuildWrapper> getDescriptor() {
        return DESCRIPTOR;
    }

    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        private int defaultLogSize;
        private int checkPeriod = 1;

        DescriptorImpl() {
            super(LogfilesizecheckerWrapper.class);
            this.load();
        }

        public String getDisplayName() {
            return Messages.Descriptor_DisplayName();
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public int getDefaultLogSize() {
            return this.defaultLogSize;
        }

        public void setDefaultLogSize(int size) {
            this.defaultLogSize = size;
        }

        public int getCheckPeriod() {
            return this.checkPeriod;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String size = formData.getString("defaultLogSize");
            String delay = formData.getString("checkPeriod");
            this.defaultLogSize = size != null ? Integer.parseInt(size) : 0;
            this.checkPeriod = delay != null ? Integer.parseInt(delay) : 1;
            this.save();
            return super.configure(req, formData);
        }
    }

    private static class LogSizeTimerTaskDisposer
    extends SimpleBuildWrapper.Disposer {
        private static final long serialVersionUID = 204030731559819462L;
        private transient LogSizeTimerTask logSizeTimerTask;

        public LogSizeTimerTaskDisposer(LogSizeTimerTask logSizeTimerTask) {
            this.logSizeTimerTask = logSizeTimerTask;
        }

        public void tearDown(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
            if (this.logSizeTimerTask != null) {
                this.logSizeTimerTask.cancel();
            }
        }
    }

    private static class LogSizeTimerTask
    extends SafeTimerTask {
        private final Run<?, ?> build;
        private final TaskListener listener;
        private final int allowedLogSize;
        private final boolean failBuild;

        private LogSizeTimerTask(Run<?, ?> build, TaskListener listener, int allowedLogSize, boolean failBuild) {
            this.build = build;
            this.listener = listener;
            this.allowedLogSize = allowedLogSize;
            this.failBuild = failBuild;
        }

        public void doRun() {
            Executor e;
            if (this.build.getLogText().length() > (long)this.allowedLogSize * 0x100000L && (e = this.build.getExecutor()) != null && !e.isInterrupted()) {
                this.listener.getLogger().println(">>> Max Log Size reached " + this.allowedLogSize + "(MB). Aborting <<<");
                e.interrupt(this.failBuild ? Result.FAILURE : Result.ABORTED);
            }
        }
    }
}

