/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.maskpasswords;

import com.michelin.cio.hudson.plugins.maskpasswords.MaskPasswordsConfig;
import com.michelin.cio.hudson.plugins.maskpasswords.MaskPasswordsOutputStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.console.ConsoleLogFilter;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.Secret;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.tasks.SimpleBuildWrapper;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public final class MaskPasswordsBuildWrapper
extends SimpleBuildWrapper {
    private final List<VarPasswordPair> varPasswordPairs;
    private static final Logger LOGGER = Logger.getLogger(MaskPasswordsBuildWrapper.class.getName());

    @DataBoundConstructor
    public MaskPasswordsBuildWrapper(List<VarPasswordPair> varPasswordPairs) {
        this.varPasswordPairs = varPasswordPairs;
    }

    public ConsoleLogFilter createLoggerDecorator(Run<?, ?> build) {
        ParametersAction params;
        ArrayList<String> allPasswords = new ArrayList<String>();
        MaskPasswordsConfig config = MaskPasswordsConfig.getInstance();
        List<VarPasswordPair> globalVarPasswordPairs = config.getGlobalVarPasswordPairs();
        for (VarPasswordPair globalVarPasswordPair : globalVarPasswordPairs) {
            allPasswords.add(globalVarPasswordPair.getPassword());
        }
        if (this.varPasswordPairs != null) {
            for (VarPasswordPair varPasswordPair : this.varPasswordPairs) {
                String password = varPasswordPair.getPassword();
                if (!StringUtils.isNotBlank((String)password)) continue;
                allPasswords.add(password);
            }
        }
        if ((params = (ParametersAction)build.getAction(ParametersAction.class)) != null) {
            for (ParameterValue param : params) {
                if (!config.isMasked(param.getClass().getName())) continue;
                EnvVars env = new EnvVars();
                param.buildEnvironment(build, env);
                String password = (String)env.get((Object)param.getName());
                if (!StringUtils.isNotBlank((String)password)) continue;
                allPasswords.add(password);
            }
        }
        return new FilterImpl(allPasswords);
    }

    public void makeBuildVariables(AbstractBuild build, Map<String, String> variables) {
        MaskPasswordsConfig config = MaskPasswordsConfig.getInstance();
        List<VarPasswordPair> globalVarPasswordPairs = config.getGlobalVarPasswordPairs();
        for (VarPasswordPair globalVarPasswordPair : globalVarPasswordPairs) {
            variables.put(globalVarPasswordPair.getVar(), globalVarPasswordPair.getPassword());
        }
        if (this.varPasswordPairs != null) {
            for (VarPasswordPair varPasswordPair : this.varPasswordPairs) {
                if (!StringUtils.isNotBlank((String)varPasswordPair.getVar())) continue;
                variables.put(varPasswordPair.getVar(), varPasswordPair.getPassword());
            }
        }
    }

    public void makeSensitiveBuildVariables(AbstractBuild build, Set<String> sensitiveVariables) {
        TreeMap<String, String> variables = new TreeMap<String, String>();
        this.makeBuildVariables(build, variables);
        sensitiveVariables.addAll(variables.keySet());
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
    }

    public List<VarPasswordPair> getVarPasswordPairs() {
        return this.varPasswordPairs;
    }

    public static final class ConverterImpl
    implements Converter {
        private static final String VAR_PASSWORD_PAIRS_NODE = "varPasswordPairs";
        private static final String VAR_PASSWORD_PAIR_NODE = "varPasswordPair";
        private static final String VAR_ATT = "var";
        private static final String PASSWORD_ATT = "password";

        public boolean canConvert(Class clazz) {
            return clazz.equals(MaskPasswordsBuildWrapper.class);
        }

        public void marshal(Object o, HierarchicalStreamWriter writer, MarshallingContext mc) {
            MaskPasswordsBuildWrapper maskPasswordsBuildWrapper = (MaskPasswordsBuildWrapper)((Object)o);
            if (maskPasswordsBuildWrapper.getVarPasswordPairs() != null) {
                writer.startNode(VAR_PASSWORD_PAIRS_NODE);
                for (VarPasswordPair varPasswordPair : maskPasswordsBuildWrapper.getVarPasswordPairs()) {
                    if (StringUtils.isBlank((String)varPasswordPair.getPassword())) continue;
                    writer.startNode(VAR_PASSWORD_PAIR_NODE);
                    writer.addAttribute(VAR_ATT, varPasswordPair.getVar());
                    writer.addAttribute(PASSWORD_ATT, varPasswordPair.getPasswordAsSecret().getEncryptedValue());
                    writer.endNode();
                }
                writer.endNode();
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext uc) {
            ArrayList<VarPasswordPair> varPasswordPairs = new ArrayList<VarPasswordPair>();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                if (reader.getNodeName().equals(VAR_PASSWORD_PAIRS_NODE)) {
                    while (reader.hasMoreChildren()) {
                        reader.moveDown();
                        if (reader.getNodeName().equals(VAR_PASSWORD_PAIR_NODE)) {
                            varPasswordPairs.add(new VarPasswordPair(reader.getAttribute(VAR_ATT), reader.getAttribute(PASSWORD_ATT)));
                        } else {
                            LOGGER.log(Level.WARNING, "Encountered incorrect node name: Expected \"varPasswordPair\", got \"{0}\"", reader.getNodeName());
                        }
                        reader.moveUp();
                    }
                    reader.moveUp();
                    continue;
                }
                LOGGER.log(Level.WARNING, "Encountered incorrect node name: \"{0}\"", reader.getNodeName());
            }
            return new MaskPasswordsBuildWrapper(varPasswordPairs);
        }
    }

    @Extension(ordinal=1000.0)
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public DescriptorImpl() {
            super(MaskPasswordsBuildWrapper.class);
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            try {
                this.getConfig().clear();
                LOGGER.fine("Processing the maskedParamDefs and selectedMaskedParamDefs JSON objects");
                JSONObject submittedForm = req.getSubmittedForm();
                JSONArray paramDefinitions = submittedForm.getJSONArray("maskedParamDefs");
                JSONArray selectedParamDefinitions = submittedForm.getJSONArray("selectedMaskedParamDefs");
                for (int i = 0; i < selectedParamDefinitions.size(); ++i) {
                    if (!selectedParamDefinitions.getBoolean(i)) continue;
                    this.getConfig().addMaskedPasswordParameterDefinition(paramDefinitions.getString(i));
                }
                if (submittedForm.has("globalVarPasswordPairs")) {
                    Object o = submittedForm.get("globalVarPasswordPairs");
                    if (o instanceof JSONArray) {
                        JSONArray jsonArray = submittedForm.getJSONArray("globalVarPasswordPairs");
                        for (int i = 0; i < jsonArray.size(); ++i) {
                            this.getConfig().addGlobalVarPasswordPair(new VarPasswordPair(jsonArray.getJSONObject(i).getString("var"), jsonArray.getJSONObject(i).getString("password")));
                        }
                    } else if (o instanceof JSONObject) {
                        JSONObject jsonObject = submittedForm.getJSONObject("globalVarPasswordPairs");
                        this.getConfig().addGlobalVarPasswordPair(new VarPasswordPair(jsonObject.getString("var"), jsonObject.getString("password")));
                    }
                }
                MaskPasswordsConfig.save(this.getConfig());
                return true;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failed to save Mask Passwords plugin configuration", e);
                return false;
            }
        }

        public MaskPasswordsConfig getConfig() {
            return MaskPasswordsConfig.getInstance();
        }

        public String getDisplayName() {
            return new Localizable(ResourceBundleHolder.get(MaskPasswordsBuildWrapper.class), "DisplayName", new Object[0]).toString();
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }
    }

    public static class VarPasswordPair
    implements Cloneable {
        private final String var;
        private final Secret password;

        @DataBoundConstructor
        public VarPasswordPair(String var, String password) {
            this.var = var;
            this.password = Secret.fromString((String)password);
        }

        public Object clone() {
            return new VarPasswordPair(this.getVar(), this.getPassword());
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VarPasswordPair other = (VarPasswordPair)obj;
            return !(this.var == null ? other.var != null : !this.var.equals(other.var));
        }

        public String getVar() {
            return this.var;
        }

        public String getPassword() {
            return Secret.toString((Secret)this.password);
        }

        public Secret getPasswordAsSecret() {
            return this.password;
        }

        public int hashCode() {
            int hash = 3;
            hash = 67 * hash + (this.var != null ? this.var.hashCode() : 0);
            return hash;
        }
    }

    private static final class FilterImpl
    extends ConsoleLogFilter
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final List<Secret> allPasswords = new ArrayList<Secret>();

        FilterImpl(List<String> allPasswords) {
            for (String password : allPasswords) {
                this.allPasswords.add(Secret.fromString((String)password));
            }
        }

        public OutputStream decorateLogger(AbstractBuild _ignore, OutputStream logger) throws IOException, InterruptedException {
            ArrayList<String> passwords = new ArrayList<String>();
            for (Secret password : this.allPasswords) {
                passwords.add(password.getPlainText());
            }
            return new MaskPasswordsOutputStream(logger, passwords);
        }
    }
}

