/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.maskpasswords;

import com.michelin.cio.hudson.plugins.maskpasswords.MaskPasswordsBuildWrapper;
import hudson.ExtensionList;
import hudson.XmlFile;
import hudson.model.Hudson;
import hudson.model.ParameterDefinition;
import hudson.model.PasswordParameterDefinition;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest;

public class MaskPasswordsConfig {
    private static final String CONFIG_FILE = "com.michelin.cio.hudson.plugins.maskpasswords.MaskPasswordsConfig.xml";
    private static MaskPasswordsConfig config;
    private Set<String> maskPasswordsParamDefClasses = new LinkedHashSet<String>();
    private transient Set<String> maskPasswordsParamValueClasses;
    private List<MaskPasswordsBuildWrapper.VarPasswordPair> globalVarPasswordPairs;
    private static final String CLASS_NAME;
    private static final Logger LOGGER;

    public MaskPasswordsConfig() {
        this.addMaskedPasswordParameterDefinition(PasswordParameterDefinition.class.getName());
        this.addMaskedPasswordParameterDefinition(com.michelin.cio.hudson.plugins.passwordparam.PasswordParameterDefinition.class.getName());
    }

    public void addGlobalVarPasswordPair(MaskPasswordsBuildWrapper.VarPasswordPair varPasswordPair) {
        if (StringUtils.isBlank((String)varPasswordPair.getVar()) || StringUtils.isBlank((String)varPasswordPair.getPassword())) {
            return;
        }
        this.getGlobalVarPasswordPairsList().add(varPasswordPair);
    }

    public void addMaskedPasswordParameterDefinition(String className) {
        this.maskPasswordsParamDefClasses.add(className);
    }

    public void clear() {
        this.maskPasswordsParamDefClasses.clear();
        this.getGlobalVarPasswordPairsList().clear();
    }

    public static MaskPasswordsConfig getInstance() {
        if (config == null) {
            config = MaskPasswordsConfig.load();
        }
        return config;
    }

    private static XmlFile getConfigFile() {
        return new XmlFile(new File(Hudson.getInstance().getRootDir(), CONFIG_FILE));
    }

    public List<MaskPasswordsBuildWrapper.VarPasswordPair> getGlobalVarPasswordPairs() {
        ArrayList<MaskPasswordsBuildWrapper.VarPasswordPair> r = new ArrayList<MaskPasswordsBuildWrapper.VarPasswordPair>(this.getGlobalVarPasswordPairsList().size());
        for (MaskPasswordsBuildWrapper.VarPasswordPair varPasswordPair : this.getGlobalVarPasswordPairsList()) {
            r.add((MaskPasswordsBuildWrapper.VarPasswordPair)varPasswordPair.clone());
        }
        return r;
    }

    private List<MaskPasswordsBuildWrapper.VarPasswordPair> getGlobalVarPasswordPairsList() {
        if (this.globalVarPasswordPairs == null) {
            this.globalVarPasswordPairs = new ArrayList<MaskPasswordsBuildWrapper.VarPasswordPair>();
        }
        return this.globalVarPasswordPairs;
    }

    public static Map<String, String> getParameterDefinitions() {
        HashMap<String, String> params = new HashMap<String, String>();
        ExtensionList paramExtensions = Hudson.getInstance().getExtensionList(ParameterDefinition.ParameterDescriptor.class);
        for (ParameterDefinition.ParameterDescriptor paramExtension : paramExtensions) {
            params.put(paramExtension.getClass().getEnclosingClass().getName(), paramExtension.getDisplayName());
        }
        return params;
    }

    public boolean isMasked(String paramValueClassName) {
        try {
            if (this.maskPasswordsParamValueClasses == null) {
                this.maskPasswordsParamValueClasses = new LinkedHashSet<String>();
                for (String paramDefClassName : this.maskPasswordsParamDefClasses) {
                    final Class<?> paramDefClass = Hudson.getInstance().getPluginManager().uberClassLoader.loadClass(paramDefClassName);
                    ArrayList<Method> methods = new ArrayList<Method>(){
                        {
                            try {
                                this.add(paramDefClass.getMethod("getDefaultParameterValue", new Class[0]));
                            }
                            catch (Exception e) {
                                LOGGER.log(Level.INFO, "No getDefaultParameterValue(String) method for " + paramDefClass);
                            }
                            try {
                                this.add(paramDefClass.getMethod("createValue", String.class));
                            }
                            catch (Exception e) {
                                LOGGER.log(Level.INFO, "No createValue(String) method for " + paramDefClass);
                            }
                            try {
                                this.add(paramDefClass.getMethod("createValue", StaplerRequest.class, JSONObject.class));
                            }
                            catch (Exception e) {
                                LOGGER.log(Level.INFO, "No createValue(StaplerRequest, JSONObject) method for " + paramDefClass);
                            }
                        }
                    };
                    for (Method m : methods) {
                        this.maskPasswordsParamValueClasses.add(m.getReturnType().getName());
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error while initializing Mask Passwords: " + e);
            return false;
        }
        return this.maskPasswordsParamValueClasses.contains(paramValueClassName);
    }

    public boolean isSelected(String paramDefClassName) {
        return this.maskPasswordsParamDefClasses.contains(paramDefClassName);
    }

    public static MaskPasswordsConfig load() {
        LOGGER.entering(CLASS_NAME, "load");
        try {
            return (MaskPasswordsConfig)MaskPasswordsConfig.getConfigFile().read();
        }
        catch (FileNotFoundException e) {
            LOGGER.log(Level.WARNING, "No configuration found for Mask Passwords plugin");
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unable to load Mask Passwords plugin configuration from com.michelin.cio.hudson.plugins.maskpasswords.MaskPasswordsConfig.xml", e);
        }
        return new MaskPasswordsConfig();
    }

    public static void save(MaskPasswordsConfig config) throws IOException {
        LOGGER.entering(CLASS_NAME, "save");
        MaskPasswordsConfig.getConfigFile().write((Object)config);
        LOGGER.exiting(CLASS_NAME, "save");
    }

    static {
        CLASS_NAME = MaskPasswordsConfig.class.getName();
        LOGGER = Logger.getLogger(CLASS_NAME);
    }
}

