/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.maskpasswords;

import hudson.console.LineTransformationOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class MaskPasswordsOutputStream
extends LineTransformationOutputStream {
    private static final String MASKED_PASSWORD = "********";
    private final OutputStream logger;
    private final Pattern passwordsAsPattern;

    public MaskPasswordsOutputStream(OutputStream logger, Collection<String> passwords) {
        this.logger = logger;
        if (passwords != null && passwords.size() > 0) {
            StringBuilder regex = new StringBuilder().append('(');
            int nbMaskedPasswords = 0;
            for (String password : passwords) {
                if (!StringUtils.isNotEmpty((String)password)) continue;
                regex.append(Pattern.quote(password));
                regex.append('|');
                ++nbMaskedPasswords;
            }
            if (nbMaskedPasswords++ >= 1) {
                regex.deleteCharAt(regex.length() - 1);
                regex.append(')');
                this.passwordsAsPattern = Pattern.compile(regex.toString());
            } else {
                this.passwordsAsPattern = null;
            }
        } else {
            this.passwordsAsPattern = null;
        }
    }

    protected void eol(byte[] bytes, int len) throws IOException {
        String line = new String(bytes, 0, len);
        if (this.passwordsAsPattern != null) {
            line = this.passwordsAsPattern.matcher(line).replaceAll(MASKED_PASSWORD);
        }
        this.logger.write(line.getBytes());
    }
}

