/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.passwordparam;

import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.ParameterValue;
import hudson.model.Run;
import hudson.util.Secret;
import hudson.util.VariableResolver;
import org.kohsuke.stapler.DataBoundConstructor;

public class PasswordParameterValue
extends ParameterValue {
    private final transient Secret value;

    public PasswordParameterValue(String name, Secret value, String description) {
        super(name, description);
        this.value = value;
    }

    @DataBoundConstructor
    public PasswordParameterValue(String name, String value, String description) {
        super(name, description);
        this.value = Secret.fromString((String)value);
    }

    public void buildEnvironment(Run<?, ?> build, EnvVars env) {
        env.put(this.name.toUpperCase(), this.value != null ? Secret.toString((Secret)this.value) : null);
    }

    public VariableResolver<String> createVariableResolver(AbstractBuild<?, ?> build) {
        return new VariableResolver<String>(){

            public String resolve(String name) {
                return PasswordParameterValue.this.name.equals(name) ? (PasswordParameterValue.this.value != null ? Secret.toString((Secret)PasswordParameterValue.this.value) : null) : null;
            }
        };
    }

    public final boolean isSensitive() {
        return true;
    }

    public String getValue() {
        return this.value != null ? Secret.toString((Secret)this.value) : null;
    }
}

