/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.maskpasswords;

import com.google.common.annotations.VisibleForTesting;
import com.michelin.cio.hudson.plugins.maskpasswords.MaskPasswordsBuildWrapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.XmlFile;
import hudson.cli.CLICommand;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.PasswordParameterDefinition;
import hudson.model.PasswordParameterValue;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.structs.describable.CustomDescribableModel;
import org.jenkinsci.plugins.structs.describable.UninstantiatedDescribable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class MaskPasswordsConfig {
    private static final String CONFIG_FILE = "com.michelin.cio.hudson.plugins.maskpasswords.MaskPasswordsConfig.xml";
    private static Object CONFIG_FILE_LOCK = new Object();
    @GuardedBy(value="CONFIG_FILE_LOCK")
    private static MaskPasswordsConfig config;
    @GuardedBy(value="this")
    private Set<String> maskPasswordsParamDefClasses;
    @Nonnull
    @GuardedBy(value="this")
    private transient Set<String> paramValueCache_maskedClasses = new HashSet<String>();
    @Nonnull
    @GuardedBy(value="this")
    private transient Set<String> paramValueCache_nonMaskedClasses = new HashSet<String>();
    private List<MaskPasswordsBuildWrapper.VarPasswordPair> globalVarPasswordPairs;
    @Deprecated
    public List<MaskPasswordsBuildWrapper.VarMaskRegex> globalVarMaskRegexes;
    public List<VarMaskRegexEntry> globalVarMaskRegexesU;
    public HashMap<String, MaskPasswordsBuildWrapper.VarMaskRegex> globalVarMaskRegexesMap;
    private boolean globalVarEnableGlobally;
    private static final String CLASS_NAME;
    private static final Logger LOGGER;

    public MaskPasswordsConfig() {
        this.maskPasswordsParamDefClasses = new LinkedHashSet<String>();
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="readResolve()")
    private Object readResolve() {
        MaskPasswordsConfig maskPasswordsConfig = this;
        synchronized (maskPasswordsConfig) {
            if (this.paramValueCache_maskedClasses == null) {
                this.paramValueCache_maskedClasses = new HashSet<String>();
            }
            if (this.paramValueCache_nonMaskedClasses == null) {
                this.paramValueCache_nonMaskedClasses = new HashSet<String>();
            }
        }
        return this;
    }

    private boolean isGlobalVarMaskRegexesNull() {
        return this.globalVarMaskRegexesMap == null || this.globalVarMaskRegexesU == null;
    }

    public void addGlobalVarPasswordPair(MaskPasswordsBuildWrapper.VarPasswordPair varPasswordPair) {
        if (StringUtils.isBlank((String)varPasswordPair.getVar()) || varPasswordPair.getPlainTextPassword() == null) {
            LOGGER.fine("addGlobalVarPasswordPair NOT adding pair with null var or password");
            return;
        }
        this.getGlobalVarPasswordPairsList().add(varPasswordPair);
    }

    public void addGlobalVarMaskRegex(MaskPasswordsBuildWrapper.VarMaskRegex varMaskRegex) {
        this.addGlobalVarMaskRegex("", varMaskRegex);
    }

    public void addGlobalVarMaskRegex(String name, String regex) {
        this.addGlobalVarMaskRegex(name, new MaskPasswordsBuildWrapper.VarMaskRegex(regex));
    }

    public void addGlobalVarMaskRegex(String name, MaskPasswordsBuildWrapper.VarMaskRegex varMaskRegex) {
        if (StringUtils.isBlank((String)varMaskRegex.getRegex())) {
            LOGGER.fine("addGlobalVarMaskRegex NOT adding null regex");
            return;
        }
        if (StringUtils.isBlank((String)name)) {
            LOGGER.fine("Generating default numbered key for VarMaskRegex");
            name = "VarMaskRegex" + this.getGlobalVarMaskRegexesMap().size();
        }
        HashMap<String, MaskPasswordsBuildWrapper.VarMaskRegex> regexMap = this.getGlobalVarMaskRegexesMap();
        regexMap.put(name, varMaskRegex);
        this.getGlobalVarMaskRegexesUList().clear();
        for (Map.Entry<String, MaskPasswordsBuildWrapper.VarMaskRegex> entry : this.getGlobalVarMaskRegexesMap().entrySet()) {
            this.getGlobalVarMaskRegexesUList().add(new VarMaskRegexEntry(entry.getKey(), entry.getValue()));
        }
        MaskPasswordsConfig.saveSafeIO(this);
    }

    public void removeGlobalVarMaskRegexByName(@Nonnull String name) {
        MaskPasswordsBuildWrapper.VarMaskRegex r;
        if (!this.isGlobalVarMaskRegexesNull() && (r = this.getGlobalVarMaskRegexesMap().get(name)) != null) {
            VarMaskRegexEntry e = new VarMaskRegexEntry(name, r);
            this.getGlobalVarMaskRegexesMap().remove(name);
            this.getGlobalVarMaskRegexesUList().remove(e);
        }
        MaskPasswordsConfig.saveSafeIO(this);
    }

    public void removeGlobalVarMaskRegex(String name, String regex) {
        if (!this.isGlobalVarMaskRegexesNull()) {
            HashMap<String, MaskPasswordsBuildWrapper.VarMaskRegex> map;
            MaskPasswordsBuildWrapper.VarMaskRegex r;
            VarMaskRegexEntry e = new VarMaskRegexEntry(name, regex);
            if (this.getGlobalVarMaskRegexesUList().remove(e) && (r = (map = this.getGlobalVarMaskRegexesMap()).get(name)) != null && r.getRegex() != null && regex != null && r.getRegex().equals(regex)) {
                map.remove(name);
            }
        }
        MaskPasswordsConfig.saveSafeIO(this);
    }

    public synchronized void addMaskedPasswordParameterDefinition(String className) {
        this.maskPasswordsParamDefClasses.add(className);
        this.paramValueCache_nonMaskedClasses.clear();
    }

    public void setGlobalVarEnabledGlobally(boolean state) {
        this.globalVarEnableGlobally = state;
    }

    @Restricted(value={NoExternalUse.class})
    @VisibleForTesting
    public final synchronized void reset() {
        this.clear();
        this.addMaskedPasswordParameterDefinition(PasswordParameterDefinition.class.getName());
        this.addMaskedPasswordParameterDefinition(com.michelin.cio.hudson.plugins.passwordparam.PasswordParameterDefinition.class.getName());
    }

    public synchronized void clear() {
        this.maskPasswordsParamDefClasses.clear();
        this.getGlobalVarPasswordPairsList().clear();
        this.getGlobalVarMaskRegexesList().clear();
        this.getGlobalVarMaskRegexesUList().clear();
        this.getGlobalVarMaskRegexesMap().clear();
        this.globalVarEnableGlobally = false;
        this.invalidatePasswordValueClassCaches();
    }

    public synchronized void clear(boolean doSave) {
        this.clear();
        if (doSave) {
            MaskPasswordsConfig.saveSafeIO(this);
        }
    }

    synchronized void invalidatePasswordValueClassCaches() {
        this.paramValueCache_maskedClasses.clear();
        this.paramValueCache_nonMaskedClasses.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MaskPasswordsConfig getInstance() {
        Object object = CONFIG_FILE_LOCK;
        synchronized (object) {
            if (config == null) {
                config = MaskPasswordsConfig.load();
            }
            return config;
        }
    }

    private static XmlFile getConfigFile() {
        return new XmlFile(new File(Jenkins.get().getRootDir(), CONFIG_FILE));
    }

    public List<MaskPasswordsBuildWrapper.VarPasswordPair> getGlobalVarPasswordPairs() {
        ArrayList<MaskPasswordsBuildWrapper.VarPasswordPair> r = new ArrayList<MaskPasswordsBuildWrapper.VarPasswordPair>(this.getGlobalVarPasswordPairsList().size());
        for (MaskPasswordsBuildWrapper.VarPasswordPair varPasswordPair : this.getGlobalVarPasswordPairsList()) {
            r.add((MaskPasswordsBuildWrapper.VarPasswordPair)varPasswordPair.clone());
        }
        return r;
    }

    public List<VarMaskRegexEntry> getGlobalVarMaskRegexesU() {
        ArrayList<VarMaskRegexEntry> r = new ArrayList<VarMaskRegexEntry>(this.getGlobalVarMaskRegexesMap().size());
        for (Map.Entry<String, MaskPasswordsBuildWrapper.VarMaskRegex> entry : this.getGlobalVarMaskRegexesMap().entrySet()) {
            r.add(new VarMaskRegexEntry(entry.getKey(), (MaskPasswordsBuildWrapper.VarMaskRegex)entry.getValue().clone()));
        }
        return r;
    }

    private List<MaskPasswordsBuildWrapper.VarPasswordPair> getGlobalVarPasswordPairsList() {
        if (this.globalVarPasswordPairs == null) {
            this.globalVarPasswordPairs = new ArrayList<MaskPasswordsBuildWrapper.VarPasswordPair>();
        }
        return this.globalVarPasswordPairs;
    }

    @Deprecated
    public List<MaskPasswordsBuildWrapper.VarMaskRegex> getGlobalVarMaskRegexesList() {
        if (this.globalVarMaskRegexes == null) {
            this.globalVarMaskRegexes = new ArrayList<MaskPasswordsBuildWrapper.VarMaskRegex>();
        }
        return this.globalVarMaskRegexes;
    }

    public List<VarMaskRegexEntry> getGlobalVarMaskRegexesUList() {
        if (this.globalVarMaskRegexesU == null) {
            this.globalVarMaskRegexesU = new ArrayList<VarMaskRegexEntry>();
        }
        return this.globalVarMaskRegexesU;
    }

    public HashMap<String, MaskPasswordsBuildWrapper.VarMaskRegex> getGlobalVarMaskRegexesMap() {
        if (this.globalVarMaskRegexesMap == null) {
            this.globalVarMaskRegexesMap = new HashMap();
            LOGGER.info("Initializing global var mask regexes map");
            if (this.getGlobalVarMaskRegexesList().size() > 0) {
                for (int i = 0; i < this.getGlobalVarMaskRegexesList().size(); ++i) {
                    this.globalVarMaskRegexesMap.put("Regex_" + String.valueOf(i), this.getGlobalVarMaskRegexesList().get(i));
                }
                this.getGlobalVarMaskRegexesList().clear();
                try {
                    MaskPasswordsConfig.save(this);
                }
                catch (IOException e) {
                    LOGGER.info("IO Exception when trying to initialize global var mask value map from list:\n" + e.getMessage());
                }
            }
        }
        return this.globalVarMaskRegexesMap;
    }

    public static Map<String, String> getParameterDefinitions() {
        HashMap<String, String> params = new HashMap<String, String>();
        ExtensionList paramExtensions = Jenkins.getActiveInstance().getExtensionList(ParameterDefinition.ParameterDescriptor.class);
        for (ParameterDefinition.ParameterDescriptor paramExtension : paramExtensions) {
            params.put(paramExtension.getClass().getEnclosingClass().getName(), paramExtension.getDisplayName());
        }
        return params;
    }

    public boolean isEnabledGlobally() {
        return this.globalVarEnableGlobally;
    }

    @Deprecated
    public synchronized boolean isMasked(@Nonnull String paramValueClassName) {
        return this.isMasked(null, paramValueClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMasked(@CheckForNull ParameterValue value, @Nonnull String paramValueClassName) {
        if (value != null && value.isSensitive()) {
            return true;
        }
        MaskPasswordsConfig maskPasswordsConfig = this;
        synchronized (maskPasswordsConfig) {
            if (this.paramValueCache_maskedClasses.contains(paramValueClassName)) {
                return true;
            }
            if (this.paramValueCache_nonMaskedClasses.contains(paramValueClassName)) {
                return false;
            }
            boolean guessSo = this.guessIfShouldMask(paramValueClassName);
            if (guessSo) {
                this.paramValueCache_maskedClasses.add(paramValueClassName);
                return true;
            }
            LOGGER.log(Level.WARNING, "Identified the {0} class as a ParameterValue class, which does not require masking. It may be false-negative", paramValueClassName);
            this.paramValueCache_nonMaskedClasses.add(paramValueClassName);
            return false;
        }
    }

    synchronized boolean guessIfShouldMask(@Nonnull String paramValueClassName) {
        Class<?> valueClass;
        for (String paramDefClassName : this.maskPasswordsParamDefClasses) {
            Class<?> paramDefClass;
            try {
                paramDefClass = Jenkins.getActiveInstance().getPluginManager().uberClassLoader.loadClass(paramDefClassName);
            }
            catch (ClassNotFoundException ex) {
                LOGGER.log(Level.WARNING, "Cannot check ParamDef for masking " + paramDefClassName, ex);
                continue;
            }
            this.tryProcessMethod(paramDefClass, "getDefaultParameterValue", true, new Class[0]);
            this.tryProcessMethod(paramDefClass, "createValue", true, StaplerRequest.class, JSONObject.class);
            this.tryProcessMethod(paramDefClass, "createValue", true, StaplerRequest.class);
            this.tryProcessMethod(paramDefClass, "createValue", true, CLICommand.class, String.class);
            this.tryProcessMethod(paramDefClass, "createValue", false, String.class);
            if (!this.paramValueCache_maskedClasses.contains(paramValueClassName)) continue;
            return true;
        }
        try {
            valueClass = Jenkins.getActiveInstance().getPluginManager().uberClassLoader.loadClass(paramValueClassName);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to load class for the ParameterValue " + paramValueClassName, ex);
            return false;
        }
        return PasswordParameterValue.class.isAssignableFrom(valueClass);
    }

    private synchronized void tryProcessMethod(Class<?> clazz, String methodName, boolean expectedToExist, Class<?> ... parameterTypes) {
        Method method;
        try {
            method = clazz.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            Level logLevel;
            Level level = logLevel = expectedToExist ? Level.INFO : Level.CONFIG;
            if (LOGGER.isLoggable(logLevel)) {
                String methodSpec = String.format("%s(%s)", methodName, StringUtils.join((Object[])parameterTypes, (String)","));
                LOGGER.log(logLevel, "No method {0} for class {1}", new Object[]{methodSpec, clazz});
            }
            return;
        }
        catch (RuntimeException ex) {
            Level logLevel;
            Level level = logLevel = expectedToExist ? Level.INFO : Level.CONFIG;
            if (LOGGER.isLoggable(logLevel)) {
                String methodSpec = String.format("%s(%s)", methodName, StringUtils.join((Object[])parameterTypes, (String)","));
                LOGGER.log(logLevel, "Failed to retrieve the method {0} for class {1}", new Object[]{methodSpec, clazz});
            }
            return;
        }
        Class<?> returnType = method.getReturnType();
        if (ParameterValue.class.isAssignableFrom(returnType) && !ParameterValue.class.equals(returnType)) {
            this.paramValueCache_maskedClasses.add(returnType.getName());
        }
    }

    public synchronized boolean isSelected(String paramDefClassName) {
        return this.maskPasswordsParamDefClasses.contains(paramDefClassName);
    }

    public static MaskPasswordsConfig load() {
        LOGGER.entering(CLASS_NAME, "load");
        try {
            MaskPasswordsConfig file = (MaskPasswordsConfig)MaskPasswordsConfig.getConfigFile().read();
            return (MaskPasswordsConfig)MaskPasswordsConfig.getConfigFile().read();
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            LOGGER.log(Level.WARNING, "No configuration found for Mask Passwords plugin");
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unable to load Mask Passwords plugin configuration from com.michelin.cio.hudson.plugins.maskpasswords.MaskPasswordsConfig.xml", e);
        }
        LOGGER.log(Level.FINE, "No Mask Passwords config file loaded; using defaults");
        return new MaskPasswordsConfig();
    }

    public static void save(MaskPasswordsConfig config) throws IOException {
        LOGGER.entering(CLASS_NAME, "save");
        MaskPasswordsConfig.getConfigFile().write((Object)config);
        LOGGER.exiting(CLASS_NAME, "save");
    }

    static void saveSafeIO(MaskPasswordsConfig config) {
        try {
            MaskPasswordsConfig.save(config);
        }
        catch (IOException e) {
            LOGGER.warning("Failed to save MaskPasswordsConfig due to IOException: " + e.getMessage());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MaskPasswordsConfigFile Regexes:[\n");
        for (Map.Entry<String, MaskPasswordsBuildWrapper.VarMaskRegex> entry : this.getGlobalVarMaskRegexesMap().entrySet()) {
            sb.append(entry.getKey() + " : " + entry.getValue().getRegex() + "\n");
        }
        sb.append("]");
        return sb.toString();
    }

    static {
        CLASS_NAME = MaskPasswordsConfig.class.getName();
        LOGGER = Logger.getLogger(CLASS_NAME);
    }

    public static class VarMaskRegexEntry
    extends AbstractDescribableImpl<VarMaskRegexEntry>
    implements Cloneable {
        private String key;
        private MaskPasswordsBuildWrapper.VarMaskRegex value;

        @DataBoundConstructor
        public VarMaskRegexEntry(String key, String value) {
            this.key = key;
            this.value = new MaskPasswordsBuildWrapper.VarMaskRegex(value);
        }

        public VarMaskRegexEntry(String key, MaskPasswordsBuildWrapper.VarMaskRegex value) {
            this.key = key;
            this.value = value;
        }

        public VarMaskRegexEntry(MaskPasswordsBuildWrapper.VarMaskRegex value) {
            this.key = "";
            this.value = value;
        }

        public String getName() {
            return this.key;
        }

        public void setName(String name) {
            this.key = name;
        }

        public MaskPasswordsBuildWrapper.VarMaskRegex getRegex() {
            return this.value;
        }

        public void setRegex(MaskPasswordsBuildWrapper.VarMaskRegex regex) {
            this.value = regex;
        }

        public String getKey() {
            return this.getName();
        }

        public void setKey(String key) {
            this.key = key;
        }

        public MaskPasswordsBuildWrapper.VarMaskRegex getValue() {
            return this.getRegex();
        }

        public void setValue(MaskPasswordsBuildWrapper.VarMaskRegex regex) {
            this.setRegex(regex);
        }

        public String getRegexString() {
            if (this.value == null) {
                return "";
            }
            return this.value.getRegex();
        }

        public String toString() {
            return this.key + ":" + this.value;
        }

        @SuppressFBWarnings(value={"CN_IDIOM_NO_SUPER_CALL"}, justification="We do not expect anybody to use this class.If they do, they must override clone() as well")
        public Object clone() {
            return new VarMaskRegexEntry(this.getName(), this.getRegex());
        }

        public int hashCode() {
            int hash = 3;
            hash = 67 * hash + (this.key != null ? this.key.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (!this.getClass().equals(other.getClass())) {
                return false;
            }
            VarMaskRegexEntry otherE = (VarMaskRegexEntry)other;
            return this.getName().equals(otherE.getName()) && this.getRegex().equals(otherE.getRegex());
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<VarMaskRegexEntry>
        implements CustomDescribableModel {
            public String getDisplayName() {
                return VarMaskRegexEntry.class.getName();
            }

            @Nonnull
            public UninstantiatedDescribable customUninstantiate(@Nonnull UninstantiatedDescribable step) {
                Map arguments = step.getArguments();
                HashMap newMap1 = new HashMap();
                newMap1.put("name", arguments.get("name"));
                newMap1.put("value", arguments.get("value"));
                return step.withArguments(newMap1);
            }

            @Nonnull
            public Map<String, Object> customInstantiate(@Nonnull Map<String, Object> arguments) {
                HashMap<String, Object> newMap = new HashMap<String, Object>();
                newMap.put("name", arguments.get("name"));
                newMap.put("value", new MaskPasswordsBuildWrapper.VarMaskRegex((String)arguments.get("value")));
                return newMap;
            }
        }
    }
}

