/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.maskpasswords;

import com.michelin.cio.hudson.plugins.util.MaskPasswordsUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.console.LineTransformationOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;

public class MaskPasswordsOutputStream
extends LineTransformationOutputStream {
    private final OutputStream logger;
    private final List<Pattern> passwordsAsPatterns;
    private final String runName;

    public MaskPasswordsOutputStream(OutputStream logger, @CheckForNull Collection<String> passwords, @CheckForNull Collection<String> regexes, String runName) {
        this.logger = logger;
        this.runName = runName != null ? runName : "";
        this.passwordsAsPatterns = new ArrayList<Pattern>();
        if (passwords != null) {
            StringBuilder pwRegex = new StringBuilder().append('(');
            int pwCount = 0;
            for (String pw : passwords) {
                if (!StringUtils.isNotEmpty((String)pw)) continue;
                ++pwCount;
                pwRegex.append(Pattern.quote(pw));
                pwRegex.append('|');
                try {
                    String encodedPassword = URLEncoder.encode(pw, "UTF-8");
                    if (encodedPassword.equals(pw)) continue;
                    pwRegex.append(Pattern.quote(encodedPassword));
                    pwRegex.append('|');
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
            if (pwCount > 0) {
                pwRegex.deleteCharAt(pwRegex.length() - 1);
                pwRegex.append(')');
                this.passwordsAsPatterns.add(Pattern.compile(pwRegex.toString()));
            }
        }
        if (regexes != null) {
            for (String r : regexes) {
                this.passwordsAsPatterns.add(Pattern.compile(r));
            }
        }
    }

    public MaskPasswordsOutputStream(OutputStream logger, @CheckForNull Collection<String> passwords) {
        this(logger, passwords, null);
    }

    public MaskPasswordsOutputStream(OutputStream logger, @CheckForNull Collection<String> passwords, @CheckForNull Collection<String> regexes) {
        this(logger, passwords, regexes, "");
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="Open TODO item for wider rework")
    protected void eol(byte[] bytes, int len) throws IOException {
        String line = new String(bytes, 0, len);
        if (this.passwordsAsPatterns != null && line != null) {
            line = MaskPasswordsUtil.secretsMaskPatterns(this.passwordsAsPatterns, line, this.runName);
        }
        this.logger.write(line.getBytes());
    }

    public void close() throws IOException {
        super.close();
        this.logger.close();
    }

    public void flush() throws IOException {
        super.flush();
        this.logger.flush();
    }
}

