/*
 * Decompiled with CFR 0.152.
 */
package hudson.matrix;

import hudson.DescriptorExtensionList;
import hudson.ExtensionPoint;
import hudson.RestrictedSince;
import hudson.Util;
import hudson.matrix.AxisDescriptor;
import hudson.matrix.JDKAxis;
import hudson.matrix.LabelAxis;
import hudson.matrix.MatrixBuild;
import hudson.matrix.TextAxis;
import hudson.model.AbstractDescribableImpl;
import hudson.util.QuotedStringTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class Axis
extends AbstractDescribableImpl<Axis>
implements Comparable<Axis>,
Iterable<String>,
ExtensionPoint {
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    public final String name;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="1.463")
    public final List<String> values;

    public Axis(String name, List<String> values) {
        if (values == null || values.isEmpty()) {
            values = Collections.emptyList();
        }
        this.name = name;
        this.values = new ArrayList<String>(values);
    }

    public Axis(String name, String ... values) {
        this(name, Arrays.asList(values));
    }

    @DataBoundConstructor
    public Axis(String name, String valueString) {
        this.name = name;
        this.values = new ArrayList<String>(Arrays.asList(Util.tokenize((String)valueString)));
    }

    @Deprecated
    public boolean isSystem() {
        return false;
    }

    @Override
    public Iterator<String> iterator() {
        return this.getValues().iterator();
    }

    public int size() {
        return this.getValues().size();
    }

    public String value(int index) {
        return this.getValues().get(index);
    }

    public int indexOf(String value) {
        return this.values.indexOf(value);
    }

    @Override
    public int compareTo(Axis that) {
        return this.name.compareTo(that.name);
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 41 * hash + (this.values != null ? this.values.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Axis other = (Axis)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.values == other.values || this.values != null && this.values.equals(other.values);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public List<String> rebuild(MatrixBuild.MatrixBuildExecution context) {
        return this.getValues();
    }

    public AxisDescriptor getDescriptor() {
        return (AxisDescriptor)super.getDescriptor();
    }

    public String toString() {
        return this.name + "={" + String.join((CharSequence)",", this.values) + '}';
    }

    public String getValueString() {
        int len = 0;
        for (String value : this.values) {
            len += value.length();
        }
        char delim = len > 30 ? (char)'\n' : ' ';
        StringBuilder buf = new StringBuilder(len + this.values.size() * 3);
        for (String value : this.values) {
            if (buf.length() != 0) {
                buf.append(delim);
            }
            buf.append(QuotedStringTokenizer.quote((String)value, (String)""));
        }
        return buf.toString();
    }

    public static Axis parsePrefixed(StaplerRequest req, String name) {
        ArrayList<String> values = new ArrayList<String>();
        String prefix = name + ".";
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String paramName = (String)e.nextElement();
            if (!paramName.startsWith(prefix)) continue;
            values.add(paramName.substring(prefix.length()));
        }
        if (values.isEmpty()) {
            return null;
        }
        return new Axis(name, values);
    }

    public Object readResolve() {
        if (this.getClass() != Axis.class) {
            return this;
        }
        if (this.getName().equals("jdk")) {
            return new JDKAxis(this.getValues());
        }
        if (this.getName().equals("label")) {
            return new LabelAxis(this.getName(), this.getValues());
        }
        return new TextAxis(this.getName(), this.getValues());
    }

    public static DescriptorExtensionList<Axis, AxisDescriptor> all() {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins != null) {
            return jenkins.getDescriptorList(Axis.class);
        }
        return DescriptorExtensionList.createDescriptorList((Jenkins)null, Axis.class);
    }

    public void addBuildVariable(String value, Map<String, String> map) {
        map.put(this.name, value);
    }
}

