/*
 * Decompiled with CFR 0.152.
 */
package hudson.matrix;

import hudson.Extension;
import hudson.Util;
import hudson.matrix.Axis;
import hudson.matrix.AxisDescriptor;
import hudson.matrix.Messages;
import hudson.model.AbstractProject;
import hudson.model.labels.LabelExpression;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class LabelExpAxis
extends Axis {
    @DataBoundConstructor
    public LabelExpAxis(String name, String values) {
        super(name, LabelExpAxis.getExprValues(values));
    }

    public LabelExpAxis(String name, List<String> values) {
        super(name, values);
    }

    @Override
    public boolean isSystem() {
        return true;
    }

    @Override
    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.getActiveInstance().getDescriptorOrDie(this.getClass());
    }

    public String getValuesString() {
        StringBuffer sb = new StringBuffer();
        for (String item : this.getValues()) {
            sb.append(item);
            sb.append("\n");
        }
        return sb.toString();
    }

    public static List<String> getExprValues(String valuesString) {
        String[] exprs;
        LinkedList<String> expressions = new LinkedList<String>();
        for (String expr : exprs = valuesString.split("\n")) {
            expressions.add(Util.fixEmptyAndTrim((String)expr));
        }
        expressions.remove(null);
        return expressions;
    }

    @Extension
    public static class DescriptorImpl
    extends AxisDescriptor {
        public String getDisplayName() {
            return Messages.LabelExpAxis_DisplayName();
        }

        @Override
        public boolean isInstantiable() {
            Jenkins j = Jenkins.getActiveInstance();
            return !j.getNodes().isEmpty() || !j.clouds.isEmpty();
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckLabelExpr(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String value) {
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return FormValidation.error((String)"No expressions provided");
            }
            ArrayList<FormValidation> validations = new ArrayList<FormValidation>();
            for (String expr : LabelExpAxis.getExprValues(value)) {
                FormValidation validation = LabelExpression.validate((String)expr, project);
                validations.add(validation);
            }
            return FormValidation.aggregate(validations);
        }
    }
}

