/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.mercurial.MercurialInstallation;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Cache {
    private final String remote;
    private final StandardUsernameCredentials credentials;
    private final String hash;
    private final ReentrantLock masterLock = new ReentrantLock(true);
    private final Map<String, ReentrantLock> slaveNodesLocksMap = new HashMap<String, ReentrantLock>();
    private static final Map<String, Cache> CACHES = new HashMap<String, Cache>();

    private Cache(String remote, String hash, StandardUsernameCredentials credentials) {
        this.remote = remote;
        this.hash = hash;
        this.credentials = credentials;
    }

    @NonNull
    public static synchronized Cache fromURL(String remote, StandardUsernameCredentials credentials) {
        String h = Cache.hashSource(remote, credentials);
        Cache cache = CACHES.get(h);
        if (cache == null) {
            cache = new Cache(remote, h, credentials);
            CACHES.put(h, cache);
        }
        return cache;
    }

    private synchronized ReentrantLock getLockForSlaveNode(String node) {
        ReentrantLock lock = this.slaveNodesLocksMap.get(node);
        if (lock == null) {
            lock = new ReentrantLock(true);
            this.slaveNodesLocksMap.put(node, lock);
        }
        return lock;
    }

    /*
     * Exception decompiling
     */
    @CheckForNull
    FilePath repositoryCache(MercurialInstallation inst, Node node, Launcher launcher, TaskListener listener, boolean useTimeout) throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 8 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static String hashSource(String source, StandardUsernameCredentials credentials) {
        BigInteger hash;
        if (!source.endsWith("/")) {
            source = source + "/";
        }
        Matcher m = Pattern.compile(".+[/]([^/:]+)(:\\d+)?[/]?").matcher(source);
        String digestible = credentials == null ? source : source + '#' + credentials.getId();
        try {
            hash = new BigInteger(1, MessageDigest.getInstance("SHA-1").digest(digestible.getBytes("UTF-8")));
        }
        catch (Exception x) {
            throw new AssertionError((Object)x);
        }
        return String.format("%040X%s%s", hash, m.matches() ? "-" + m.group(1) : "", credentials == null ? "" : "-" + credentials.getUsername().replace("@", "-at-"));
    }
}

