/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.mercurial.Cache;
import hudson.plugins.mercurial.HgExe;
import hudson.plugins.mercurial.MercurialInstallation;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.plugins.mercurial.browser.HgBrowser;
import hudson.scm.RepositoryBrowser;
import hudson.scm.RepositoryBrowsers;
import hudson.scm.SCM;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.SCMSourceOwner;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MercurialSCMSource
extends SCMSource {
    private final String installation;
    private final String source;
    private final String credentialsId;
    private final String branchPattern;
    private final String modules;
    private final String subdir;
    private final HgBrowser browser;
    private final boolean clean;

    @DataBoundConstructor
    public MercurialSCMSource(String id, String installation, String source, String credentialsId, String branchPattern, String modules, String subdir, HgBrowser browser, boolean clean) {
        super(id);
        this.installation = installation;
        this.source = source;
        this.credentialsId = credentialsId;
        this.branchPattern = branchPattern;
        this.modules = modules;
        this.subdir = subdir;
        this.browser = browser;
        this.clean = clean;
    }

    public String getInstallation() {
        return this.installation;
    }

    public String getSource() {
        return this.source;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getBranchPattern() {
        return this.branchPattern;
    }

    public String getModules() {
        return this.modules;
    }

    public String getSubdir() {
        return this.subdir;
    }

    public HgBrowser getBrowser() {
        return this.browser;
    }

    public boolean isClean() {
        return this.clean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void retrieve(SCMHeadObserver observer, TaskListener listener) throws IOException, InterruptedException {
        MercurialInstallation inst = MercurialSCM.findInstallation(this.installation);
        if (inst == null) {
            listener.error("No configured Mercurial installation");
            return;
        }
        if (!inst.isUseCaches()) {
            listener.error("Mercurial installation " + this.installation + " does not support caches");
            return;
        }
        Jenkins node = Jenkins.getInstance();
        Launcher launcher = node.createLauncher(listener);
        StandardUsernameCredentials credentials = this.getCredentials();
        FilePath cache = Cache.fromURL(this.source, credentials).repositoryCache(inst, (Node)node, launcher, listener, true);
        if (cache == null) {
            listener.error("Could not use caches, not fetching branch heads");
            return;
        }
        HgExe hg = new HgExe(inst, credentials, launcher, (Node)node, listener, new EnvVars());
        try {
            String heads = hg.popen(cache, listener, true, new ArgumentListBuilder(new String[]{"heads", "--template", "{node} {branch}\\n"}));
            Pattern p = Pattern.compile(Util.fixNull((String)this.branchPattern).length() == 0 ? ".+" : this.branchPattern);
            for (String line : heads.split("\r?\n")) {
                String[] nodeBranch = line.split(" ", 2);
                String name = nodeBranch[1];
                if (p.matcher(name).matches()) {
                    listener.getLogger().println("Found branch " + name);
                    SCMHead branch = new SCMHead(name);
                    observer.observe(branch, (SCMRevision)new MercurialRevision(branch, nodeBranch[0]));
                    continue;
                }
                listener.getLogger().println("Ignoring branch " + name);
            }
        }
        finally {
            hg.close();
        }
    }

    @SuppressWarnings(value={"DB_DUPLICATE_BRANCHES"})
    public SCM build(SCMHead head, SCMRevision revision) {
        String rev = revision == null ? head.getName() : ((MercurialRevision)revision).hash;
        return new MercurialSCM(this.installation, this.source, revision == null ? MercurialSCM.RevisionType.BRANCH : MercurialSCM.RevisionType.BRANCH, rev, this.modules, this.subdir, this.browser, this.clean, this.credentialsId, false);
    }

    @CheckForNull
    private StandardUsernameCredentials getCredentials() {
        if (this.credentialsId != null) {
            for (StandardUsernameCredentials standardUsernameCredentials : MercurialSCMSource.availableCredentials(this.getOwner(), this.source)) {
                if (!standardUsernameCredentials.getId().equals(this.credentialsId)) continue;
                return standardUsernameCredentials;
            }
        }
        return null;
    }

    private static List<? extends StandardUsernameCredentials> availableCredentials(@CheckForNull SCMSourceOwner owner, @CheckForNull String source) {
        return CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (Item)owner, null, (List)URIRequirementBuilder.fromUri((String)source).build());
    }

    private static final class MercurialRevision
    extends SCMRevision {
        private final String hash;

        MercurialRevision(SCMHead branch, String hash) {
            super(branch);
            this.hash = hash;
        }

        public boolean equals(Object obj) {
            return obj instanceof MercurialRevision && ((MercurialRevision)((Object)obj)).hash.equals(this.hash);
        }

        public int hashCode() {
            return this.hash.hashCode();
        }

        public String toString() {
            return this.getHead().getName() + ":" + this.hash;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends SCMSourceDescriptor {
        public String getDisplayName() {
            return "Mercurial";
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath SCMSourceOwner owner, @QueryParameter String source) {
            if (owner == null || !owner.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            return new StandardUsernameListBoxModel().withEmptySelection().withAll((Iterable)MercurialSCMSource.availableCredentials(owner, source));
        }

        public FormValidation doCheckBranchPattern(@QueryParameter String value) {
            try {
                Pattern.compile(value);
                return FormValidation.ok();
            }
            catch (PatternSyntaxException x) {
                return FormValidation.error((String)x.getDescription());
            }
        }

        public List<Descriptor<RepositoryBrowser<?>>> getBrowserDescriptors() {
            return RepositoryBrowsers.filter(HgBrowser.class);
        }
    }
}

