/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import hudson.Extension;
import hudson.model.AbstractModelObject;
import hudson.model.Item;
import hudson.model.UnprotectedRootAction;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.plugins.mercurial.MercurialSCMSource;
import hudson.plugins.mercurial.Messages;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.triggers.SCMTrigger;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwners;
import jenkins.triggers.SCMTriggerItem;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
public class MercurialStatus
extends AbstractModelObject
implements UnprotectedRootAction {
    private static final Logger LOGGER = Logger.getLogger(MercurialStatus.class.getName());

    public String getDisplayName() {
        return Messages.MercurialStatus_mercurial();
    }

    public String getSearchUrl() {
        return this.getUrlName();
    }

    public String getIconFileName() {
        return null;
    }

    public String getUrlName() {
        return "mercurial";
    }

    static boolean looselyMatches(URI notifyUri, String repository) {
        boolean result = false;
        try {
            URI repositoryUri = new URI(repository);
            result = Objects.equal((Object)notifyUri.getHost(), (Object)repositoryUri.getHost()) && Objects.equal((Object)notifyUri.getPath(), (Object)repositoryUri.getPath()) && Objects.equal((Object)notifyUri.getQuery(), (Object)repositoryUri.getQuery());
        }
        catch (URISyntaxException ex) {
            LOGGER.log(Level.SEVERE, "could not parse repository uri " + repository, ex);
        }
        return result;
    }

    public HttpResponse doNotifyCommit(@QueryParameter(required=true) String url) throws ServletException, IOException {
        SecurityContext securityContext = ACL.impersonate((Authentication)ACL.SYSTEM);
        try {
            HttpResponse httpResponse = this.handleNotifyCommit(new URI(url));
            return httpResponse;
        }
        catch (URISyntaxException ex) {
            throw HttpResponses.error((int)400, (Throwable)ex);
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)securityContext);
        }
    }

    private HttpResponse handleNotifyCommit(URI url) throws ServletException, IOException {
        final ArrayList projects = Lists.newArrayList();
        boolean scmFound = false;
        boolean urlFound = false;
        block0: for (Item project : Jenkins.getInstance().getAllItems()) {
            SCMTriggerItem scmTriggerItem = SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem((Item)project);
            if (scmTriggerItem == null) continue;
            for (SCM scm : scmTriggerItem.getSCMs()) {
                if (!(scm instanceof MercurialSCM)) continue;
                scmFound = true;
                MercurialSCM hg = (MercurialSCM)scm;
                String repository = hg.getSource();
                if (repository == null) {
                    LOGGER.log(Level.WARNING, "project {0} is using source control but does not identify a repository", project.getFullName());
                    continue;
                }
                LOGGER.log(Level.INFO, "for {0}: {1} vs. {2}", new Object[]{project.getFullName(), url, repository});
                if (!MercurialStatus.looselyMatches(url, repository)) continue;
                urlFound = true;
                SCMTrigger trigger = scmTriggerItem.getSCMTrigger();
                if (trigger == null || trigger.isIgnorePostCommitHooks()) {
                    LOGGER.log(Level.INFO, "No SCMTrigger on {0}", project.getFullName());
                    continue;
                }
                LOGGER.log(Level.INFO, "Triggering polling of {0}", project.getFullName());
                trigger.run();
                projects.add(project);
                continue block0;
            }
        }
        for (Item project : SCMSourceOwners.all()) {
            for (SCMSource source : project.getSCMSources()) {
                if (!(source instanceof MercurialSCMSource)) continue;
                scmFound = true;
                MercurialSCMSource hgSource = (MercurialSCMSource)source;
                String repository = hgSource.getSource();
                if (repository == null) {
                    LOGGER.log(Level.WARNING, "project {0} is using source control but does not identify a repository", project.getFullName());
                    continue;
                }
                LOGGER.log(Level.INFO, "for {0}: {1} vs. {2}", new Object[]{project.getFullName(), url, repository});
                if (!MercurialStatus.looselyMatches(url, repository)) continue;
                urlFound = true;
                LOGGER.log(Level.INFO, "Scheduling {0} for refresh", project.getFullName());
                project.onSCMSourceUpdated(source);
                projects.add(project);
            }
        }
        final String msg = !scmFound ? "No Mercurial jobs found" : (!urlFound ? "No Mercurial jobs found using repository: " + url : null);
        return new HttpResponse(){

            public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
                rsp.setStatus(200);
                rsp.setContentType("text/plain");
                for (Item p : projects) {
                    rsp.addHeader("Triggered", p.getAbsoluteUrl());
                }
                PrintWriter w = rsp.getWriter();
                for (Item p : projects) {
                    w.println("Scheduled polling of " + p.getFullName());
                }
                if (msg != null) {
                    w.println(msg);
                }
            }
        };
    }
}

