/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial.browser;

import hudson.Util;
import hudson.model.Descriptor;
import hudson.plugins.mercurial.MercurialChangeSet;
import hudson.plugins.mercurial.browser.HgWeb;
import hudson.scm.RepositoryBrowser;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HgBrowser
extends RepositoryBrowser<MercurialChangeSet> {
    transient MercurialChangeSet current;
    private final URL url;
    private static final long serialVersionUID = 1L;

    public URL getChangeSetLink(MercurialChangeSet changeset) throws IOException {
        throw new UnsupportedOperationException("Method is not implemented for HgBrowser");
    }

    public URL getFileLink(String path) throws MalformedURLException {
        throw new UnsupportedOperationException("Method is not implemented for HgBrowser");
    }

    public URL getDiffLink(String path) throws MalformedURLException {
        throw new UnsupportedOperationException("Method is not implemented for HgBrowser");
    }

    void checkCurrentIsNotNull() {
        if (this.current == null) {
            throw new IllegalStateException("current changeset must not be null, did you forget to call 'getChangeSetLink'?");
        }
    }

    HgBrowser(String url) throws MalformedURLException {
        this.url = HgBrowser.normalizeToEndWithSlash((URL)new URL(url));
    }

    public URL getUrl() {
        return this.url;
    }

    public Object readResolve() {
        if (!((Object)((Object)this)).getClass().equals(HgBrowser.class)) {
            return this;
        }
        try {
            return new HgWeb(this.url.toExternalForm());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class HgBrowserDescriptor
    extends Descriptor<RepositoryBrowser<?>> {
        protected HgBrowserDescriptor() {
        }

        public abstract FormValidation doCheckUrl(@QueryParameter String var1);

        protected final FormValidation _doCheckUrl(@QueryParameter String url) {
            if ((url = Util.fixNull((String)url)).length() == 0) {
                return FormValidation.error((String)"URL is mandatory");
            }
            try {
                URL u = new URL(url);
                if (u.getPath().endsWith("/")) {
                    return this.check(u);
                }
                return FormValidation.warning((String)"Browser URL should end with a slash (/)");
            }
            catch (MalformedURLException x) {
                return FormValidation.error((Throwable)x, (String)"Invalid URL");
            }
        }

        protected FormValidation check(URL url) {
            return FormValidation.ok();
        }
    }
}

