/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.msbuild;

import hudson.console.LineTransformationOutputStream;
import hudson.plugins.msbuild.MSBuildErrorNote;
import hudson.plugins.msbuild.MSBuildWarningNote;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.regex.Matcher;

public class MSBuildConsoleAnnotator
extends LineTransformationOutputStream {
    private final OutputStream out;
    private final Charset charset;
    private int numberOfWarnings = 0;
    private int numberOfErrors = 0;

    public MSBuildConsoleAnnotator(OutputStream out, Charset charset) {
        this.out = out;
        this.charset = charset;
    }

    public int getNumberOfWarnings() {
        return this.numberOfWarnings;
    }

    public int getNumberOfErrors() {
        return this.numberOfErrors;
    }

    protected void eol(byte[] b, int len) throws IOException {
        String line = this.charset.decode(ByteBuffer.wrap(b, 0, len)).toString();
        Matcher m = MSBuildErrorNote.PATTERN.matcher(line = this.trimEOL(line));
        if (m.matches()) {
            new MSBuildErrorNote().encodeTo(this.out);
            ++this.numberOfErrors;
        }
        if ((m = MSBuildWarningNote.PATTERN.matcher(line)).matches()) {
            new MSBuildWarningNote().encodeTo(this.out);
            ++this.numberOfWarnings;
        }
        this.out.write(b, 0, len);
    }

    public void close() throws IOException {
        super.close();
        this.out.close();
    }
}

