/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.msbuild;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.msbuild.MSBuildConsoleAnnotator;
import hudson.plugins.msbuild.Messages;
import hudson.plugins.msbuild.MsBuildConsoleParser;
import hudson.plugins.msbuild.MsBuildInstallation;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.tools.ToolInstallation;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class MsBuildBuilder
extends Builder {
    private final String msBuildName;
    private final String msBuildFile;
    private final String cmdLineArgs;
    private final boolean buildVariablesAsProperties;
    private transient boolean continueOnBuilFailure;
    private final boolean continueOnBuildFailure;
    private final boolean unstableIfWarnings;
    private final boolean doNotUseChcpCommand;

    @Deprecated
    public MsBuildBuilder(String msBuildName, String msBuildFile, String cmdLineArgs, boolean buildVariablesAsProperties, boolean continueOnBuildFailure, boolean unstableIfWarnings) {
        this(msBuildName, msBuildFile, cmdLineArgs, buildVariablesAsProperties, continueOnBuildFailure, unstableIfWarnings, false);
    }

    @DataBoundConstructor
    public MsBuildBuilder(String msBuildName, String msBuildFile, String cmdLineArgs, boolean buildVariablesAsProperties, boolean continueOnBuildFailure, boolean unstableIfWarnings, boolean doNotUseChcpCommand) {
        this.msBuildName = msBuildName;
        this.msBuildFile = msBuildFile;
        this.cmdLineArgs = cmdLineArgs;
        this.buildVariablesAsProperties = buildVariablesAsProperties;
        this.continueOnBuildFailure = continueOnBuildFailure;
        this.unstableIfWarnings = unstableIfWarnings;
        this.doNotUseChcpCommand = doNotUseChcpCommand;
    }

    public String getMsBuildFile() {
        return this.msBuildFile;
    }

    public String getMsBuildName() {
        return this.msBuildName;
    }

    public String getCmdLineArgs() {
        return this.cmdLineArgs;
    }

    public boolean getBuildVariablesAsProperties() {
        return this.buildVariablesAsProperties;
    }

    public boolean getContinueOnBuildFailure() {
        return this.continueOnBuildFailure;
    }

    public boolean getUnstableIfWarnings() {
        return this.unstableIfWarnings;
    }

    public boolean getDoNotUseChcpCommand() {
        return this.doNotUseChcpCommand;
    }

    public MsBuildInstallation getMsBuild() {
        DescriptorImpl descriptor = (DescriptorImpl)this.getDescriptor();
        for (MsBuildInstallation i : descriptor.getInstallations()) {
            if (this.msBuildName == null || !i.getName().equals(this.msBuildName)) continue;
            return i;
        }
        return null;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        FilePath msBuildFilePath;
        EnvVars env;
        ArgumentListBuilder args = new ArgumentListBuilder();
        String execName = "msbuild.exe";
        MsBuildInstallation ai = this.getMsBuild();
        if (ai == null) {
            listener.getLogger().println("Path To MSBuild.exe: " + execName);
            args.add(execName);
        } else {
            env = build.getEnvironment((TaskListener)listener);
            Node node = Computer.currentComputer().getNode();
            if (node != null) {
                ai = ai.forNode(node, (TaskListener)listener);
                ai = ai.forEnvironment(env);
                String pathToMsBuild = MsBuildBuilder.getToolFullPath(launcher, ai.getHome(), execName);
                FilePath exec = new FilePath(launcher.getChannel(), pathToMsBuild);
                try {
                    if (!exec.exists()) {
                        listener.fatalError(pathToMsBuild + " doesn't exist");
                        return false;
                    }
                }
                catch (IOException e) {
                    listener.fatalError("Failed checking for existence of " + pathToMsBuild);
                    return false;
                }
                listener.getLogger().println("Path To MSBuild.exe: " + pathToMsBuild);
                args.add(pathToMsBuild);
                if (ai.getDefaultArgs() != null) {
                    args.add(MsBuildBuilder.tokenizeArgs(ai.getDefaultArgs()));
                }
            }
        }
        env = build.getEnvironment((TaskListener)listener);
        String normalizedArgs = this.cmdLineArgs.replaceAll("[\t\r\n]+", " ");
        normalizedArgs = Util.replaceMacro((String)normalizedArgs, (Map)env);
        normalizedArgs = Util.replaceMacro((String)normalizedArgs, (Map)build.getBuildVariables());
        if (normalizedArgs.trim().length() > 0) {
            args.add(MsBuildBuilder.tokenizeArgs(normalizedArgs));
        }
        Map<String, String> propertiesVariables = this.getPropertiesVariables(build);
        if (this.buildVariablesAsProperties && !propertiesVariables.isEmpty()) {
            StringBuffer parameters = new StringBuffer();
            parameters.append("/p:");
            for (Map.Entry<String, String> entry : propertiesVariables.entrySet()) {
                parameters.append(entry.getKey()).append("=").append(entry.getValue()).append(";");
            }
            parameters.delete(parameters.length() - 1, parameters.length());
            args.add(parameters.toString());
        }
        String normalizedFile = null;
        if (this.msBuildFile != null && this.msBuildFile.trim().length() != 0) {
            normalizedFile = this.msBuildFile.replaceAll("[\t\r\n]+", " ");
            normalizedFile = Util.replaceMacro((String)normalizedFile, (Map)env);
            if (!(normalizedFile = Util.replaceMacro((String)normalizedFile, (Map)build.getBuildVariables())).isEmpty()) {
                args.add(normalizedFile);
            }
        }
        FilePath pwd = build.getModuleRoot();
        if (normalizedFile != null && !(msBuildFilePath = pwd.child(normalizedFile)).exists()) {
            pwd = build.getWorkspace();
        }
        if (!launcher.isUnix()) {
            int cpi;
            if (!this.doNotUseChcpCommand && (cpi = MsBuildBuilder.getCodePageIdentifier(build.getCharset())) != 0) {
                args.prepend(new String[]{"chcp", String.valueOf(cpi), "&"});
            }
            args.prepend(new String[]{"cmd.exe", "/C", "\""});
            args.add(new String[]{"\"", "&&", "exit", "%%ERRORLEVEL%%"});
        } else {
            listener.fatalError("Unable to use this plugin on this kind of operation system");
        }
        try {
            listener.getLogger().println(String.format("Executing the command %s from %s", args.toStringWithQuote(), pwd));
            MsBuildConsoleParser mbcp = new MsBuildConsoleParser(listener.getLogger(), build.getCharset());
            MSBuildConsoleAnnotator annotator = new MSBuildConsoleAnnotator(listener.getLogger(), build.getCharset());
            int r = launcher.launch().cmds(args).envs((Map)env).stdout((OutputStream)((Object)mbcp)).stdout((OutputStream)((Object)annotator)).pwd(pwd).join();
            if (this.unstableIfWarnings && mbcp.getNumberOfWarnings() > 0) {
                listener.getLogger().println("> Set build UNSTABLE because there are warnings.");
                build.setResult(Result.UNSTABLE);
            }
            return this.continueOnBuildFailure ? true : r == 0;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            build.setResult(Result.FAILURE);
            return false;
        }
    }

    private Map<String, String> getPropertiesVariables(AbstractBuild build) {
        Map buildVariables = build.getBuildVariables();
        Set sensitiveBuildVariables = build.getSensitiveBuildVariables();
        if (sensitiveBuildVariables == null || sensitiveBuildVariables.isEmpty()) {
            return buildVariables;
        }
        for (String sensitiveBuildVariable : sensitiveBuildVariables) {
            buildVariables.remove(sensitiveBuildVariable);
        }
        return buildVariables;
    }

    static String getToolFullPath(Launcher launcher, String pathToTool, String execName) throws IOException, InterruptedException {
        String fullPathToMsBuild = pathToTool != null ? pathToTool : "";
        FilePath exec = new FilePath(launcher.getChannel(), fullPathToMsBuild);
        if (exec.isDirectory()) {
            if (!fullPathToMsBuild.endsWith("\\")) {
                fullPathToMsBuild = fullPathToMsBuild + "\\";
            }
            fullPathToMsBuild = fullPathToMsBuild + execName;
        }
        return fullPathToMsBuild;
    }

    public Descriptor<Builder> getDescriptor() {
        return super.getDescriptor();
    }

    static String[] tokenizeArgs(String args) {
        if (args == null) {
            return null;
        }
        String[] tokenize = Util.tokenize((String)args);
        if (args.endsWith("\\")) {
            tokenize[tokenize.length - 1] = tokenize[tokenize.length - 1] + "\\";
        }
        return tokenize;
    }

    private static int getCodePageIdentifier(Charset charset) {
        String s_charset = charset.name();
        if (s_charset.equalsIgnoreCase("utf-8")) {
            return 65001;
        }
        if (s_charset.equalsIgnoreCase("ibm437")) {
            return 437;
        }
        if (s_charset.equalsIgnoreCase("ibm850")) {
            return 850;
        }
        if (s_charset.equalsIgnoreCase("ibm852")) {
            return 852;
        }
        if (s_charset.equalsIgnoreCase("shift_jis") || s_charset.equalsIgnoreCase("windows-31j")) {
            return 932;
        }
        if (s_charset.equalsIgnoreCase("us-ascii")) {
            return 20127;
        }
        if (s_charset.equalsIgnoreCase("euc-jp")) {
            return 20932;
        }
        if (s_charset.equalsIgnoreCase("iso-8859-1")) {
            return 28591;
        }
        if (s_charset.equalsIgnoreCase("iso-8859-2")) {
            return 28592;
        }
        if (s_charset.equalsIgnoreCase("IBM00858")) {
            return 858;
        }
        if (s_charset.equalsIgnoreCase("IBM775")) {
            return 775;
        }
        if (s_charset.equalsIgnoreCase("IBM855")) {
            return 855;
        }
        if (s_charset.equalsIgnoreCase("IBM857")) {
            return 857;
        }
        if (s_charset.equalsIgnoreCase("ISO-8859-4")) {
            return 28594;
        }
        if (s_charset.equalsIgnoreCase("ISO-8859-5")) {
            return 28595;
        }
        if (s_charset.equalsIgnoreCase("ISO-8859-7")) {
            return 28597;
        }
        if (s_charset.equalsIgnoreCase("ISO-8859-9")) {
            return 28599;
        }
        if (s_charset.equalsIgnoreCase("ISO-8859-13")) {
            return 28603;
        }
        if (s_charset.equalsIgnoreCase("ISO-8859-15")) {
            return 28605;
        }
        if (s_charset.equalsIgnoreCase("KOI8-R")) {
            return 20866;
        }
        if (s_charset.equalsIgnoreCase("KOI8-U")) {
            return 21866;
        }
        if (s_charset.equalsIgnoreCase("UTF-16")) {
            return 1200;
        }
        if (s_charset.equalsIgnoreCase("UTF-32")) {
            return 12000;
        }
        if (s_charset.equalsIgnoreCase("UTF-32BE")) {
            return 12001;
        }
        if (s_charset.equalsIgnoreCase("windows-1250")) {
            return 1250;
        }
        if (s_charset.equalsIgnoreCase("windows-1251")) {
            return 1251;
        }
        if (s_charset.equalsIgnoreCase("windows-1252")) {
            return 1252;
        }
        if (s_charset.equalsIgnoreCase("windows-1253")) {
            return 1253;
        }
        if (s_charset.equalsIgnoreCase("windows-1254")) {
            return 1254;
        }
        if (s_charset.equalsIgnoreCase("windows-1257")) {
            return 1257;
        }
        if (s_charset.equalsIgnoreCase("Big5")) {
            return 950;
        }
        if (s_charset.equalsIgnoreCase("EUC-KR")) {
            return 51949;
        }
        if (s_charset.equalsIgnoreCase("GB18030")) {
            return 54936;
        }
        if (s_charset.equalsIgnoreCase("GB2312")) {
            return 936;
        }
        if (s_charset.equalsIgnoreCase("IBM-Thai")) {
            return 20838;
        }
        if (s_charset.equalsIgnoreCase("IBM01140")) {
            return 1140;
        }
        if (s_charset.equalsIgnoreCase("IBM01141")) {
            return 1141;
        }
        if (s_charset.equalsIgnoreCase("IBM01142")) {
            return 1142;
        }
        if (s_charset.equalsIgnoreCase("IBM01143")) {
            return 1143;
        }
        if (s_charset.equalsIgnoreCase("IBM01144")) {
            return 1144;
        }
        if (s_charset.equalsIgnoreCase("IBM01145")) {
            return 1145;
        }
        if (s_charset.equalsIgnoreCase("IBM01146")) {
            return 1146;
        }
        if (s_charset.equalsIgnoreCase("IBM01147")) {
            return 1147;
        }
        if (s_charset.equalsIgnoreCase("IBM01148")) {
            return 1148;
        }
        if (s_charset.equalsIgnoreCase("IBM01149")) {
            return 1149;
        }
        if (s_charset.equalsIgnoreCase("IBM037")) {
            return 37;
        }
        if (s_charset.equalsIgnoreCase("IBM1026")) {
            return 1026;
        }
        if (s_charset.equalsIgnoreCase("IBM273")) {
            return 20273;
        }
        if (s_charset.equalsIgnoreCase("IBM277")) {
            return 20277;
        }
        if (s_charset.equalsIgnoreCase("IBM278")) {
            return 20278;
        }
        if (s_charset.equalsIgnoreCase("IBM280")) {
            return 20280;
        }
        if (s_charset.equalsIgnoreCase("IBM284")) {
            return 20284;
        }
        if (s_charset.equalsIgnoreCase("IBM285")) {
            return 20285;
        }
        if (s_charset.equalsIgnoreCase("IBM297")) {
            return 20297;
        }
        if (s_charset.equalsIgnoreCase("IBM420")) {
            return 20420;
        }
        if (s_charset.equalsIgnoreCase("IBM424")) {
            return 20424;
        }
        if (s_charset.equalsIgnoreCase("IBM500")) {
            return 500;
        }
        if (s_charset.equalsIgnoreCase("IBM860")) {
            return 860;
        }
        if (s_charset.equalsIgnoreCase("IBM861")) {
            return 861;
        }
        if (s_charset.equalsIgnoreCase("IBM863")) {
            return 863;
        }
        if (s_charset.equalsIgnoreCase("IBM864")) {
            return 864;
        }
        if (s_charset.equalsIgnoreCase("IBM865")) {
            return 865;
        }
        if (s_charset.equalsIgnoreCase("IBM869")) {
            return 869;
        }
        if (s_charset.equalsIgnoreCase("IBM870")) {
            return 870;
        }
        if (s_charset.equalsIgnoreCase("IBM871")) {
            return 20871;
        }
        if (s_charset.equalsIgnoreCase("ISO-2022-JP")) {
            return 50220;
        }
        if (s_charset.equalsIgnoreCase("ISO-2022-KR")) {
            return 50225;
        }
        if (s_charset.equalsIgnoreCase("ISO-8859-3")) {
            return 28593;
        }
        if (s_charset.equalsIgnoreCase("ISO-8859-6")) {
            return 28596;
        }
        if (s_charset.equalsIgnoreCase("ISO-8859-8")) {
            return 28598;
        }
        if (s_charset.equalsIgnoreCase("windows-1255")) {
            return 1255;
        }
        if (s_charset.equalsIgnoreCase("windows-1256")) {
            return 1256;
        }
        if (s_charset.equalsIgnoreCase("windows-1258")) {
            return 1258;
        }
        return 0;
    }

    @Extension
    @Symbol(value={"msbuild"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private volatile MsBuildInstallation[] installations = new MsBuildInstallation[0];

        public DescriptorImpl() {
            super(MsBuildBuilder.class);
            this.load();
        }

        public String getDisplayName() {
            return Messages.MsBuildBuilder_DisplayName();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public MsBuildInstallation[] getInstallations() {
            return Arrays.copyOf(this.installations, this.installations.length);
        }

        public void setInstallations(MsBuildInstallation ... antInstallations) {
            this.installations = antInstallations;
            this.save();
        }

        public MsBuildInstallation.DescriptorImpl getToolDescriptor() {
            return (MsBuildInstallation.DescriptorImpl)((Object)ToolInstallation.all().get(MsBuildInstallation.DescriptorImpl.class));
        }
    }
}

