/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.msbuild;

import hudson.console.LineTransformationOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MsBuildConsoleParser
extends LineTransformationOutputStream {
    private final OutputStream out;
    private final Charset charset;
    private int numberOfWarnings = -1;
    private int numberOfErrors = -1;

    public MsBuildConsoleParser(OutputStream out, Charset charset) {
        this.out = out;
        this.charset = charset;
    }

    public int getNumberOfWarnings() {
        return this.numberOfWarnings;
    }

    public int getNumberOfErrors() {
        return this.numberOfErrors;
    }

    protected void eol(byte[] b, int len) throws IOException {
        String line = this.charset.decode(ByteBuffer.wrap(b, 0, len)).toString();
        line = this.trimEOL(line);
        Pattern patternWarnings = Pattern.compile(".*\\d+\\sWarning\\(s\\).*");
        Pattern patternErrors = Pattern.compile(".*\\d+\\sError\\(s\\).*");
        Matcher mWarnings = patternWarnings.matcher(line);
        Matcher mErrors = patternErrors.matcher(line);
        if (mWarnings.matches()) {
            String[] part = line.split(" ");
            try {
                this.numberOfWarnings = Integer.parseInt(part[4]);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (mErrors.matches()) {
            String[] part = line.split(" ");
            try {
                this.numberOfErrors = Integer.parseInt(part[4]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.out.write(b, 0, len);
    }

    public void close() throws IOException {
        super.close();
        this.out.close();
    }
}

