/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.msbuild;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.msbuild.MsBuildBuilder;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import java.io.IOException;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public final class MsBuildInstallation
extends ToolInstallation
implements NodeSpecific<MsBuildInstallation>,
EnvironmentSpecific<MsBuildInstallation> {
    private final String defaultArgs;

    @DataBoundConstructor
    public MsBuildInstallation(String name, String home, String defaultArgs) {
        super(name, home, null);
        this.defaultArgs = Util.fixEmpty((String)defaultArgs);
    }

    public MsBuildInstallation forNode(Node node, TaskListener log) throws IOException, InterruptedException {
        return new MsBuildInstallation(this.getName(), this.translateFor(node, log), this.getDefaultArgs());
    }

    public MsBuildInstallation forEnvironment(EnvVars environment) {
        return new MsBuildInstallation(this.getName(), environment.expand(this.getHome()), this.getDefaultArgs());
    }

    public String getDefaultArgs() {
        return this.defaultArgs;
    }

    @Extension
    @Symbol(value={"msbuild"})
    public static class DescriptorImpl
    extends ToolDescriptor<MsBuildInstallation> {
        public String getDisplayName() {
            return "MSBuild";
        }

        public MsBuildInstallation[] getInstallations() {
            return this.getDescriptor().getInstallations();
        }

        public void setInstallations(MsBuildInstallation ... installations) {
            this.getDescriptor().setInstallations(installations);
        }

        private MsBuildBuilder.DescriptorImpl getDescriptor() {
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins != null && jenkins.getDescriptorByType(MsBuildBuilder.DescriptorImpl.class) != null) {
                return (MsBuildBuilder.DescriptorImpl)jenkins.getDescriptorByType(MsBuildBuilder.DescriptorImpl.class);
            }
            throw new NullPointerException("MsBuildBuilder.DescriptorImpl is null");
        }
    }
}

