/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.msbuild;

import hudson.Extension;
import hudson.util.ProcessKillingVeto;
import hudson.util.ProcessTreeRemoting;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.jenkinsci.Symbol;

@Extension(optional=true)
@Symbol(value={"msbuildKillingVeto"})
public class MsBuildKillingVeto
extends ProcessKillingVeto {
    private static final ProcessKillingVeto.VetoCause VETO_CAUSE = new ProcessKillingVeto.VetoCause("MSBuild Plugin vetoes killing mspdbsrv.exe, see JENKINS-9104 for all the details");

    public ProcessKillingVeto.VetoCause vetoProcessKilling(ProcessTreeRemoting.IOSProcess proc) {
        if (proc == null) {
            return null;
        }
        List cmdLine = proc.getArguments();
        if (cmdLine == null || cmdLine.isEmpty()) {
            return null;
        }
        String command = (String)cmdLine.get(0);
        String exeName = FilenameUtils.getName((String)command);
        if (exeName.toLowerCase().equals("mspdbsrv.exe")) {
            return VETO_CAUSE;
        }
        return null;
    }
}

