/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import hudson.Extension;
import hudson.Functions;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.security.AbstractPasswordBasedSecurityRealm;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import hudson.security.pam.Messages;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import java.util.logging.Logger;
import jenkins.model.IdStrategy;
import jenkins.model.Jenkins;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.userdetails.User;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.jvnet.libpam.PAM;
import org.jvnet.libpam.PAMException;
import org.jvnet.libpam.UnixUser;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.springframework.dao.DataAccessException;

public class PAMSecurityRealm
extends AbstractPasswordBasedSecurityRealm {
    private static final Logger LOGGER = Logger.getLogger(PAMSecurityRealm.class.getName());
    public final String serviceName;

    @DataBoundConstructor
    public PAMSecurityRealm(String serviceName) {
        serviceName = Util.fixEmptyAndTrim((String)serviceName);
        if (serviceName == null) {
            serviceName = "sshd";
        }
        this.serviceName = serviceName;
    }

    protected synchronized UserDetails authenticate(String username, String password) throws AuthenticationException {
        try {
            UnixUser u = new PAM(this.serviceName).authenticate(username, password);
            return new User(username, "", true, true, true, true, PAMSecurityRealm.toAuthorities(u));
        }
        catch (PAMException e) {
            throw new BadCredentialsException(e.getMessage(), (Throwable)e);
        }
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        if (!UnixUser.exists((String)username)) {
            throw new UsernameNotFoundException("No such Unix user: " + username);
        }
        try {
            UnixUser u = new UnixUser(username);
            return new User(username, "", true, true, true, true, PAMSecurityRealm.toAuthorities(u));
        }
        catch (PAMException e) {
            throw new UsernameNotFoundException("Failed to load information about Unix user: " + username, (Throwable)e);
        }
    }

    private static GrantedAuthority[] toAuthorities(UnixUser u) {
        Set groups = u.getGroups();
        GrantedAuthority[] authorities = new GrantedAuthority[groups.size() + 1];
        int i = 0;
        for (String group : groups) {
            authorities[i++] = new GrantedAuthorityImpl(group);
        }
        authorities[i] = AUTHENTICATED_AUTHORITY;
        return authorities;
    }

    public GroupDetails loadGroupByGroupname(String groupName) throws UsernameNotFoundException, DataAccessException {
        final String group = groupName.startsWith("@") ? groupName.substring(1) : groupName;
        try {
            FileSystems.getDefault().getUserPrincipalLookupService().lookupPrincipalByGroupName(groupName);
        }
        catch (IOException e) {
            throw new UsernameNotFoundException(group);
        }
        catch (UnsupportedOperationException e) {
            throw new UsernameNotFoundException("Unable to generate the lookup service to load " + group);
        }
        return new GroupDetails(){

            public String getName() {
                return group;
            }
        };
    }

    public IdStrategy getUserIdStrategy() {
        return DescriptorImpl.STRATEGY;
    }

    public IdStrategy getGroupIdStrategy() {
        return DescriptorImpl.STRATEGY;
    }

    @Extension
    public static DescriptorImpl install() {
        return Functions.isWindows() ? null : new DescriptorImpl();
    }

    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        private static final IdStrategy STRATEGY = Util.fixNull((String)System.getProperty("os.name")).contains("OS X") ? IdStrategy.CASE_INSENSITIVE : new IdStrategy.CaseSensitive();

        public String getDisplayName() {
            return Messages.PAMSecurityRealm_DisplayName();
        }

        @RequirePOST
        public FormValidation doTest() {
            Jenkins jenkins = Jenkins.get();
            if (!jenkins.hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.ok();
            }
            File s = new File("/etc/shadow");
            if (s.exists() && !s.canRead()) {
                String user;
                LOGGER.fine("/etc/shadow exists but not readable");
                String shadowOwner = null;
                String shadowGroup = null;
                PosixFileAttributes fileAttributes = null;
                try {
                    fileAttributes = Files.readAttributes(s.toPath(), PosixFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                    shadowOwner = fileAttributes.owner().getName();
                    shadowGroup = fileAttributes.group().getName();
                }
                catch (IOException e) {
                    return FormValidation.error((String)Messages.PAMSecurityRealm_ReadPermission());
                }
                catch (UnsupportedOperationException e) {
                    return FormValidation.error((String)Messages.PAMSecurityRealm_UnsupportedOperation());
                }
                String string = user = System.getProperty("user.name") != null ? Messages.PAMSecurityRealm_User(System.getProperty("user.name")) : Messages.PAMSecurityRealm_CurrentUser();
                if (fileAttributes.permissions().contains((Object)PosixFilePermission.GROUP_READ)) {
                    return FormValidation.error((String)Messages.PAMSecurityRealm_BelongToGroup(user, shadowGroup));
                }
                return FormValidation.error((String)Messages.PAMSecurityRealm_RunAsUserOrBelongToGroupAndChmod(shadowOwner, user, shadowGroup));
            }
            return FormValidation.ok((String)Messages.PAMSecurityRealm_Success());
        }
    }
}

