/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.model.queue.QueueTaskFuture;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameterFactory;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import hudson.plugins.parameterizedtrigger.BlockingBehaviour;
import hudson.plugins.parameterizedtrigger.BuildTriggerConfig;
import hudson.plugins.parameterizedtrigger.DifferentiatingAction;
import hudson.plugins.parameterizedtrigger.ResultCondition;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;

public class BlockableBuildTriggerConfig
extends BuildTriggerConfig {
    private final BlockingBehaviour block;
    public boolean buildAllNodesWithLabel;

    public BlockableBuildTriggerConfig(String projects, BlockingBehaviour block, List<AbstractBuildParameters> configs) {
        super(projects, ResultCondition.ALWAYS, false, configs);
        this.block = block;
    }

    @DataBoundConstructor
    public BlockableBuildTriggerConfig(String projects, BlockingBehaviour block, List<AbstractBuildParameterFactory> configFactories, List<AbstractBuildParameters> configs) {
        super(projects, ResultCondition.ALWAYS, false, configFactories, configs, false);
        this.block = block;
    }

    public BlockingBehaviour getBlock() {
        return this.block;
    }

    @Override
    public List<QueueTaskFuture<AbstractBuild>> perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        List<QueueTaskFuture<AbstractBuild>> r = super.perform(build, launcher, listener);
        if (this.block == null) {
            return Collections.emptyList();
        }
        return r;
    }

    @Override
    public ListMultimap<AbstractProject, QueueTaskFuture<AbstractBuild>> perform2(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        ListMultimap<AbstractProject, QueueTaskFuture<AbstractBuild>> futures = super.perform2(build, launcher, listener);
        if (this.block == null) {
            return ArrayListMultimap.create();
        }
        return futures;
    }

    @Override
    public ListMultimap<Job, QueueTaskFuture<AbstractBuild>> perform3(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        ListMultimap<Job, QueueTaskFuture<AbstractBuild>> futures = super.perform3(build, launcher, listener);
        if (this.block == null) {
            return ArrayListMultimap.create();
        }
        return futures;
    }

    @Override
    protected QueueTaskFuture schedule(AbstractBuild<?, ?> build, Job project, List<Action> list, TaskListener listener) throws InterruptedException, IOException {
        if (this.block != null) {
            while (true) {
                QueueTaskFuture f;
                if ((f = this.schedule(build, project, 0, (List<Action>)(list = ImmutableList.builder().addAll(list).add((Object)new DifferentiatingAction()).build()), listener)) != null || f == null && !this.canBeScheduled(project)) {
                    return f;
                }
                Thread.sleep(1000L);
            }
        }
        return super.schedule(build, project, (List<Action>)list, listener);
    }

    public Collection<Node> getNodes() {
        return Jenkins.get().getLabel("asrt").getNodes();
    }

    @Extension
    public static class DescriptorImpl
    extends BuildTriggerConfig.DescriptorImpl {
    }
}

