/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.parsers;

import hudson.Extension;
import hudson.plugins.performance.data.HttpSample;
import hudson.plugins.performance.descriptors.PerformanceReportParserDescriptor;
import hudson.plugins.performance.parsers.AbstractParser;
import hudson.plugins.performance.reports.PerformanceReport;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JUnitParser
extends AbstractParser {
    public static final String ISO8601_DATETIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss";

    public JUnitParser(String glob, String percentiles) {
        super(glob, percentiles, PerformanceReport.INCLUDE_ALL);
    }

    @DataBoundConstructor
    public JUnitParser(String glob, String percentiles, String filterRegex) {
        super(glob, percentiles, filterRegex);
    }

    @Override
    public String getDefaultGlobPattern() {
        return "**/TEST-*.xml";
    }

    @Override
    PerformanceReport parse(File reportFile) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        SAXParser parser = factory.newSAXParser();
        final PerformanceReport report = this.createPerformanceReport();
        report.setExcludeResponseTime(this.excludeResponseTime);
        report.setShowTrendGraphs(this.showTrendGraphs);
        report.setReportFileName(reportFile.getName());
        parser.parse(reportFile, new DefaultHandler(){
            private HttpSample currentSample;
            private int status;

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                if (("testsuite".equalsIgnoreCase(qName) || "testcase".equalsIgnoreCase(qName)) && this.status != 0) {
                    report.addSample(this.currentSample);
                    this.status = 0;
                }
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if ("testcase".equalsIgnoreCase(qName)) {
                    if (this.status != 0) {
                        report.addSample(this.currentSample);
                    }
                    this.status = 1;
                    this.currentSample = new HttpSample();
                    try {
                        String timestamp = attributes.getValue("timestamp");
                        this.currentSample.setDate(new SimpleDateFormat(JUnitParser.ISO8601_DATETIME_PATTERN).parse(timestamp));
                    }
                    catch (Exception e) {
                        this.currentSample.setDate(new Date(0L));
                    }
                    String time = attributes.getValue("time");
                    this.currentSample.setDuration(JUnitParser.parseDuration(time));
                    this.currentSample.setSuccessful(true);
                    this.currentSample.setUri(attributes.getValue("classname") + "." + attributes.getValue("name"));
                    this.currentSample.setErrorObtained(false);
                } else if ("failure".equalsIgnoreCase(qName) && this.status != 0) {
                    this.currentSample.setErrorObtained(false);
                    this.currentSample.setSuccessful(false);
                    report.addSample(this.currentSample);
                    this.status = 0;
                } else if ("error".equalsIgnoreCase(qName) && this.status != 0) {
                    this.currentSample.setErrorObtained(true);
                    this.currentSample.setSuccessful(false);
                    report.addSample(this.currentSample);
                    this.status = 0;
                }
            }
        });
        return report;
    }

    static long parseDuration(String time) {
        if (StringUtils.isEmpty((String)time)) {
            return 0L;
        }
        double duration = Double.parseDouble(time.replaceAll(",", ""));
        return (long)(duration * 1000.0);
    }

    @Extension
    public static class DescriptorImpl
    extends PerformanceReportParserDescriptor {
        public String getDisplayName() {
            return "JUnit";
        }
    }
}

