/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps.build;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.InvisibleAction;
import hudson.model.Queue;
import hudson.model.queue.FoldableAction;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.workflow.steps.StepContext;

class BuildTriggerAction
extends InvisibleAction
implements FoldableAction {
    private static final Logger LOGGER = Logger.getLogger(BuildTriggerAction.class.getName());
    @Deprecated
    private StepContext context;
    @Deprecated
    private Boolean propagate;
    private List<Trigger> triggers = new ArrayList<Trigger>();

    BuildTriggerAction(StepContext context, boolean propagate) {
        this.triggers.add(new Trigger(context, propagate));
    }

    private Object readResolve() {
        if (this.triggers == null) {
            this.triggers = new ArrayList<Trigger>();
            this.triggers.add(new Trigger(this.context, this.propagate != null ? this.propagate : true));
            this.context = null;
            this.propagate = null;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Iterable<Trigger> triggersFor(Actionable actionable) {
        ArrayList<Trigger> triggers = new ArrayList<Trigger>();
        for (BuildTriggerAction action : actionable.getActions(BuildTriggerAction.class)) {
            List<Trigger> list = action.triggers;
            synchronized (list) {
                triggers.addAll(action.triggers);
            }
        }
        return triggers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void foldIntoExisting(Queue.Item item, Queue.Task owner, List<Action> otherActions) {
        BuildTriggerAction existing = (BuildTriggerAction)item.getAction(BuildTriggerAction.class);
        if (existing == null) {
            item.addAction((Action)this);
        } else {
            List<Trigger> list = existing.triggers;
            synchronized (list) {
                existing.triggers.addAll(this.triggers);
            }
        }
        LOGGER.log(Level.FINE, "coalescing actions for {0}", item);
    }

    static class Trigger {
        final StepContext context;
        final boolean propagate;
        @CheckForNull
        Throwable interruption;

        Trigger(StepContext context, boolean propagate) {
            this.context = context;
            this.propagate = propagate;
        }
    }
}

