/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps.build;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Extension;
import hudson.console.ModelHyperlinkNote;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.CauseOfInterruption;
import jenkins.util.Timer;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.support.steps.build.BuildTriggerAction;
import org.jenkinsci.plugins.workflow.support.steps.build.DownstreamFailureCause;
import org.jenkinsci.plugins.workflow.support.steps.build.RunWrapper;

@Extension
public class BuildTriggerListener
extends RunListener<Run<?, ?>> {
    private static final Logger LOGGER = Logger.getLogger(BuildTriggerListener.class.getName());

    public void onStarted(Run<?, ?> run, TaskListener listener) {
        for (BuildTriggerAction.Trigger trigger : BuildTriggerAction.triggersFor(run)) {
            StepContext stepContext = trigger.context;
            if (stepContext != null && stepContext.isReady()) {
                LOGGER.log(Level.FINE, "started building {0} from #{1} in {2}", new Object[]{run, run.getQueueId(), stepContext});
                try {
                    TaskListener taskListener = (TaskListener)stepContext.get(TaskListener.class);
                    taskListener.getLogger().println("Starting building: " + ModelHyperlinkNote.encodeTo((String)("/" + run.getUrl()), (String)run.getFullDisplayName()));
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, null, e);
                }
                continue;
            }
            LOGGER.log(Level.FINE, "{0} unavailable in {1}", new Object[]{stepContext, run});
        }
    }

    public void onCompleted(Run<?, ?> run, @NonNull TaskListener listener) {
        for (BuildTriggerAction.Trigger trigger : BuildTriggerAction.triggersFor(run)) {
            LOGGER.log(Level.FINE, "completing {0} for {1}", new Object[]{run, trigger.context});
            if (!trigger.propagate || run.getResult() == Result.SUCCESS) {
                if (trigger.interruption == null) {
                    trigger.context.onSuccess((Object)new RunWrapper(run, false));
                    continue;
                }
                trigger.context.onFailure(trigger.interruption);
                continue;
            }
            Result result = run.getResult();
            trigger.context.onFailure((Throwable)new FlowInterruptedException(result != null ? result : Result.FAILURE, false, new CauseOfInterruption[]{new DownstreamFailureCause(run)}));
        }
        run.removeActions(BuildTriggerAction.class);
    }

    public void onDeleted(Run<?, ?> run) {
        for (BuildTriggerAction.Trigger trigger : BuildTriggerAction.triggersFor(run)) {
            Timer.get().submit(() -> trigger.context.onFailure((Throwable)new AbortException(run.getFullDisplayName() + " was deleted")));
        }
    }
}

