/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps.input;

import com.cloudbees.plugins.credentials.CredentialsParameterValue;
import com.cloudbees.plugins.credentials.builds.CredentialsParameterBinder;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import hudson.FilePath;
import hudson.Util;
import hudson.console.HyperlinkNote;
import hudson.console.ModelHyperlinkNote;
import hudson.model.Action;
import hudson.model.Failure;
import hudson.model.FileParameterValue;
import hudson.model.Job;
import hudson.model.ModelObject;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.security.SecurityRealm;
import hudson.util.HttpResponses;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.servlet.ServletException;
import jenkins.model.CauseOfInterruption;
import jenkins.model.IdStrategy;
import jenkins.model.Jenkins;
import jenkins.util.Timer;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jenkinsci.plugins.workflow.support.actions.PauseAction;
import org.jenkinsci.plugins.workflow.support.steps.input.ApproverAction;
import org.jenkinsci.plugins.workflow.support.steps.input.InputAction;
import org.jenkinsci.plugins.workflow.support.steps.input.InputStep;
import org.jenkinsci.plugins.workflow.support.steps.input.InputSubmittedAction;
import org.jenkinsci.plugins.workflow.support.steps.input.Outcome;
import org.jenkinsci.plugins.workflow.support.steps.input.POSTHyperlinkNote;
import org.jenkinsci.plugins.workflow.support.steps.input.Rejection;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class InputStepExecution
extends AbstractStepExecutionImpl
implements ModelObject {
    private static final Logger LOGGER = Logger.getLogger(InputStepExecution.class.getName());
    @StepContextParameter
    private transient Run run;
    @StepContextParameter
    private transient TaskListener listener;
    @StepContextParameter
    private transient FlowNode node;
    private Outcome outcome;
    @Inject(optional=true)
    InputStep input;
    private static final long serialVersionUID = 1L;

    public boolean start() throws Exception {
        this.getPauseAction().add(this);
        this.node.addAction((Action)new PauseAction("Input"));
        String baseUrl = '/' + this.run.getUrl() + this.getPauseAction().getUrlName() + '/';
        if (this.input.getParameters().isEmpty() && this.input.getSubmitterParameter() == null) {
            String thisUrl = baseUrl + Util.rawEncode((String)this.getId()) + '/';
            this.listener.getLogger().printf("%s%n%s or %s%n", this.input.getMessage(), POSTHyperlinkNote.encodeTo((String)(thisUrl + "proceedEmpty"), (String)this.input.getOk()), POSTHyperlinkNote.encodeTo((String)(thisUrl + "abort"), (String)"Abort"));
        } else {
            this.listener.getLogger().println(HyperlinkNote.encodeTo((String)baseUrl, (String)"Input requested"));
        }
        return false;
    }

    public void stop(Throwable cause) throws Exception {
        Timer.get().submit(new Runnable(){

            @Override
            public void run() {
                try (ACLContext context = ACL.as((Authentication)ACL.SYSTEM);){
                    InputStepExecution.this.doAbort();
                }
            }
        });
    }

    public String getId() {
        return this.input.getId();
    }

    public InputStep getInput() {
        return this.input;
    }

    public Run getRun() {
        return this.run;
    }

    public boolean isSettled() {
        return this.outcome != null;
    }

    private InputAction getPauseAction() {
        InputAction a = (InputAction)this.run.getAction(InputAction.class);
        if (a == null) {
            a = new InputAction();
            this.run.addAction((Action)a);
        }
        return a;
    }

    public String getDisplayName() {
        String message = this.getInput().getMessage();
        if (message.length() < 32) {
            return message;
        }
        return message.substring(0, 32) + "...";
    }

    @RequirePOST
    public HttpResponse doSubmit(StaplerRequest request) throws IOException, ServletException, InterruptedException {
        if (request.getParameter("proceed") != null) {
            this.doProceed(request);
        } else {
            this.doAbort();
        }
        return HttpResponses.redirectTo((String)"../../console");
    }

    @RequirePOST
    public HttpResponse doProceed(StaplerRequest request) throws IOException, ServletException, InterruptedException {
        this.preSubmissionCheck();
        Map<String, Object> v = this.parseValue(request);
        return this.proceed(v);
    }

    public HttpResponse proceed(@CheckForNull Map<String, Object> params) {
        User user = User.current();
        String approverId = null;
        if (user != null) {
            approverId = user.getId();
            this.run.addAction((Action)new ApproverAction(approverId));
            this.listener.getLogger().println("Approved by " + ModelHyperlinkNote.encodeTo((User)user));
        }
        this.node.addAction((Action)new InputSubmittedAction(approverId, params));
        Object v = params != null && params.size() == 1 ? params.values().iterator().next() : params;
        this.outcome = new Outcome(v, null);
        this.postSettlement();
        this.getContext().onSuccess(v);
        return HttpResponses.ok();
    }

    @Deprecated
    public HttpResponse proceed(Object v) {
        if (v instanceof Map) {
            return this.proceed(new HashMap<String, Object>((Map)v));
        }
        if (v == null) {
            return this.proceed(null);
        }
        return this.proceed(Collections.singletonMap("parameter", v));
    }

    @RequirePOST
    public HttpResponse doProceedEmpty() throws IOException {
        this.preSubmissionCheck();
        return this.proceed(null);
    }

    @RequirePOST
    public HttpResponse doAbort() {
        this.preAbortCheck();
        FlowInterruptedException e = new FlowInterruptedException(Result.ABORTED, new CauseOfInterruption[]{new Rejection(User.current())});
        this.outcome = new Outcome(null, (Throwable)e);
        this.postSettlement();
        this.getContext().onFailure((Throwable)e);
        return HttpResponses.ok();
    }

    private void preAbortCheck() {
        if (this.isSettled()) {
            throw new Failure("This input has been already given");
        }
        if (!this.canCancel() && !this.canSubmit()) {
            if (this.input.getSubmitter() != null) {
                throw new Failure("You need to be '" + this.input.getSubmitter() + "' (or have Job/Cancel permissions) to cancel this.");
            }
            throw new Failure("You need to have Job/Cancel permissions to cancel this.");
        }
    }

    public void preSubmissionCheck() {
        if (this.isSettled()) {
            throw new Failure("This input has been already given");
        }
        if (!this.canSubmit()) {
            if (this.input.getSubmitter() != null) {
                throw new Failure("You need to be " + this.input.getSubmitter() + " to submit this.");
            }
            throw new Failure("You need to have Job/Build permissions to submit this.");
        }
    }

    /*
     * Loose catch block
     */
    private void postSettlement() {
        block14: {
            block12: {
                this.getPauseAction().remove(this);
                this.run.save();
                if (this.node == null) break block12;
                try {
                    PauseAction.endCurrentPause((FlowNode)this.node);
                }
                catch (IOException x) {
                    LOGGER.log(Level.WARNING, "failed to end PauseAction in " + this.run, x);
                }
                break block14;
            }
            LOGGER.log(Level.WARNING, "cannot set pause end time for {0} in {1}", new Object[]{this.getId(), this.run});
            break block14;
            catch (IOException | InterruptedException | TimeoutException x) {
                block13: {
                    try {
                        LOGGER.log(Level.WARNING, "failed to remove InputAction from " + this.run, x);
                        if (this.node == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (this.node != null) {
                            try {
                                PauseAction.endCurrentPause((FlowNode)this.node);
                            }
                            catch (IOException x2) {
                                LOGGER.log(Level.WARNING, "failed to end PauseAction in " + this.run, x2);
                            }
                        } else {
                            LOGGER.log(Level.WARNING, "cannot set pause end time for {0} in {1}", new Object[]{this.getId(), this.run});
                        }
                        throw throwable;
                    }
                    try {
                        PauseAction.endCurrentPause((FlowNode)this.node);
                    }
                    catch (IOException x3) {
                        LOGGER.log(Level.WARNING, "failed to end PauseAction in " + this.run, x3);
                    }
                }
                LOGGER.log(Level.WARNING, "cannot set pause end time for {0} in {1}", new Object[]{this.getId(), this.run});
            }
        }
    }

    private boolean canCancel() {
        return !Jenkins.get().isUseSecurity() || this.getRun().getParent().hasPermission(Job.CANCEL);
    }

    private boolean canSubmit() {
        Authentication a = Jenkins.getAuthentication();
        return this.canSettle(a);
    }

    private boolean canSettle(Authentication a) {
        String submitter = this.input.getSubmitter();
        if (submitter == null) {
            return this.getRun().getParent().hasPermission(Job.BUILD);
        }
        if (!Jenkins.get().isUseSecurity() || Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
            return true;
        }
        HashSet submitters = Sets.newHashSet((Object[])submitter.split(","));
        SecurityRealm securityRealm = Jenkins.get().getSecurityRealm();
        if (this.isMemberOf(a.getName(), submitters, securityRealm.getUserIdStrategy())) {
            return true;
        }
        for (GrantedAuthority ga : a.getAuthorities()) {
            if (!this.isMemberOf(ga.getAuthority(), submitters, securityRealm.getGroupIdStrategy())) continue;
            return true;
        }
        return false;
    }

    private boolean isMemberOf(String userId, Set<String> submitters, IdStrategy idStrategy) {
        for (String submitter : submitters) {
            if (!idStrategy.equals(userId, StringUtils.trim((String)submitter))) continue;
            return true;
        }
        return false;
    }

    private Map<String, Object> parseValue(StaplerRequest request) throws ServletException, IOException, InterruptedException {
        HashMap<String, Object> mapResult = new HashMap<String, Object>();
        List<ParameterDefinition> defs = this.input.getParameters();
        HashSet<ParameterValue> vals = new HashSet<ParameterValue>(defs.size());
        Object params = request.getSubmittedForm().get("parameter");
        if (params != null) {
            for (Object o : JSONArray.fromObject((Object)params)) {
                JSONObject jo = (JSONObject)o;
                String name = jo.getString("name");
                ParameterDefinition d = null;
                for (ParameterDefinition def : defs) {
                    if (!def.getName().equals(name)) continue;
                    d = def;
                }
                if (d == null) {
                    throw new IllegalArgumentException("No such parameter definition: " + name);
                }
                ParameterValue v = d.createValue(request, jo);
                if (v == null) continue;
                vals.add(v);
                mapResult.put(name, this.convert(name, v));
            }
        }
        CredentialsParameterBinder binder = CredentialsParameterBinder.getOrCreate((Run)this.run);
        String userId = Jenkins.getAuthentication().getName();
        for (ParameterValue val : vals) {
            if (!(val instanceof CredentialsParameterValue)) continue;
            binder.bindCredentialsParameter(userId, (CredentialsParameterValue)val);
        }
        this.run.replaceAction((Action)binder);
        String valueName = this.input.getSubmitterParameter();
        if (valueName != null && !valueName.isEmpty()) {
            mapResult.put(valueName, userId);
        }
        if (mapResult.isEmpty()) {
            return null;
        }
        return mapResult;
    }

    private Object convert(String name, ParameterValue v) throws IOException, InterruptedException {
        if (v instanceof FileParameterValue) {
            FileParameterValue fv = (FileParameterValue)v;
            FilePath fp = new FilePath(this.run.getRootDir()).child(name);
            fp.copyFrom(fv.getFile());
            return fp;
        }
        return v.getValue();
    }
}

