/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.conf;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.TaskListener;
import java.io.FileNotFoundException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.MissingContextVariableException;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class WriteYamlStep
extends Step {
    private String file;
    private Object data;
    private Collection datas;
    private String charset;
    private boolean overwrite;
    private boolean returnText;

    @DataBoundConstructor
    public WriteYamlStep() {
    }

    @Deprecated
    public WriteYamlStep(Object data) {
        this();
        this.setData(data);
    }

    @Deprecated
    public WriteYamlStep(String file, Object data) {
        this();
        this.file = file;
        this.setData(data);
    }

    public String getFile() {
        return this.file;
    }

    @DataBoundSetter
    public void setFile(String file) {
        this.file = file;
    }

    public Object getData() {
        return this.data;
    }

    @DataBoundSetter
    public void setData(Object data) {
        if (!this.isValidObjectType(data)) {
            throw new IllegalArgumentException("data parameter has invalid content (no-basic classes)");
        }
        this.data = data;
    }

    public Collection getDatas() {
        return this.datas;
    }

    @DataBoundSetter
    public void setDatas(Collection datas) {
        if (!this.isValidObjectType(datas)) {
            throw new IllegalArgumentException("datas parameter has invalid content (no-basic classes)");
        }
        this.datas = datas;
    }

    public String getCharset() {
        return this.charset;
    }

    @DataBoundSetter
    public void setCharset(String charset) {
        this.charset = charset;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    @DataBoundSetter
    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean isReturnText() {
        return this.returnText;
    }

    @DataBoundSetter
    public void setReturnText(boolean returnText) {
        this.returnText = returnText;
    }

    private boolean isValidObjectType(Object obj) {
        if (obj instanceof Boolean || obj instanceof Character || obj instanceof Number || obj instanceof String || obj instanceof URL || obj instanceof Calendar || obj instanceof Date || obj instanceof UUID || obj == null) {
            return true;
        }
        if (obj instanceof Map) {
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                if (this.isValidObjectType(entry.getKey()) && this.isValidObjectType(entry.getValue())) continue;
                return false;
            }
            return true;
        }
        if (obj instanceof Collection) {
            for (Object o : (Collection)obj) {
                if (this.isValidObjectType(o)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public StepExecution start(StepContext context) throws Exception {
        if (this.returnText) {
            if (this.file != null) {
                throw new IllegalArgumentException("cannot provide both returnText and file to writeYaml");
            }
            if (this.charset != null) {
                throw new IllegalArgumentException("cannot provide both returnText and charset to writeYaml");
            }
            if (this.overwrite) {
                throw new IllegalArgumentException("cannot provide both returnText and overwrite to writeYaml");
            }
            return new ReturnTextExecution(context, this);
        }
        if (StringUtils.isBlank((String)this.file)) {
            throw new IllegalArgumentException("either file or returnText must be provided to writeYaml");
        }
        return new Execution(context, this);
    }

    public static class Execution
    extends SynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        private transient WriteYamlStep step;

        protected Execution(@NonNull StepContext context, WriteYamlStep step) {
            super(context);
            this.step = step;
        }

        protected Void run() throws Exception {
            FilePath ws = (FilePath)this.getContext().get(FilePath.class);
            if (ws == null) {
                throw new MissingContextVariableException(FilePath.class);
            }
            FilePath path = ws.child(this.step.getFile());
            if (path.isDirectory()) {
                throw new FileNotFoundException(path.getRemote() + " is a directory.");
            }
            if (!this.step.isOverwrite() && path.exists()) {
                throw new FileAlreadyExistsException(path.getRemote());
            }
            Object data = this.step.getData();
            Collection datas = this.step.getDatas();
            if (data == null && datas == null) {
                throw new IllegalArgumentException("data or datas parameter must be provided to writeYaml");
            }
            if (data != null && datas != null) {
                throw new IllegalArgumentException("only one of data or datas must be provided to writeYaml");
            }
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            options.setSplitLines(false);
            Yaml yaml = new Yaml(options);
            Charset cs = StringUtils.isEmpty((String)this.step.getCharset()) ? StandardCharsets.UTF_8 : Charset.forName(this.step.getCharset());
            try (OutputStreamWriter writer = new OutputStreamWriter(path.write(), cs);){
                if (data == null) {
                    yaml.dumpAll(datas.iterator(), (Writer)writer);
                } else {
                    yaml.dump(data, (Writer)writer);
                }
            }
            return null;
        }
    }

    private static class ReturnTextExecution
    extends SynchronousNonBlockingStepExecution<String> {
        private static final long serialVersionUID = 1L;
        private transient WriteYamlStep step;

        protected ReturnTextExecution(@NonNull StepContext context, WriteYamlStep step) {
            super(context);
            this.step = step;
        }

        protected String run() throws Exception {
            Object data = this.step.getData();
            Collection datas = this.step.getDatas();
            if (data == null && datas == null) {
                throw new IllegalArgumentException("data or datas parameter must be provided to writeYaml");
            }
            if (data != null && datas != null) {
                throw new IllegalArgumentException("only one of data or datas must be provided to writeYaml");
            }
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            options.setSplitLines(false);
            Yaml yaml = new Yaml(options);
            if (data == null) {
                return yaml.dumpAll(datas.iterator());
            }
            return yaml.dump(data);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(TaskListener.class);
        }

        public String getFunctionName() {
            return "writeYaml";
        }

        @NonNull
        public String getDisplayName() {
            return "Write a yaml from an object or objects.";
        }
    }
}

