/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.maven;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.TaskListener;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.GroovyShellDecorator;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ReadMavenPomStep
extends Step {
    private static final String ORG_APACHE_MAVEN_MODEL = "org.apache.maven.model";
    private String file;

    @DataBoundConstructor
    public ReadMavenPomStep() {
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public String getFile() {
        return this.file;
    }

    @DataBoundSetter
    public void setFile(String file) {
        this.file = file;
    }

    @Extension
    public static class WhiteLister
    extends Whitelist {
        public boolean permitsMethod(Method method, Object receiver, Object[] args) {
            if (receiver == null) {
                return false;
            }
            Class<?> aClass = receiver.getClass();
            Package aPackage = aClass.getPackage();
            if (aPackage == null) {
                return false;
            }
            String name = aPackage.getName();
            return name.equals(ReadMavenPomStep.ORG_APACHE_MAVEN_MODEL) && (method.getName().startsWith("set") || method.getName().startsWith("get") || method.getName().startsWith("add") || method.getName().startsWith("find"));
        }

        public boolean permitsConstructor(@NonNull Constructor<?> constructor, @NonNull Object[] args) {
            if (constructor == null) {
                return false;
            }
            Package aPackage = constructor.getDeclaringClass().getPackage();
            if (aPackage == null) {
                return false;
            }
            return aPackage.getName().equals(ReadMavenPomStep.ORG_APACHE_MAVEN_MODEL);
        }

        public boolean permitsStaticMethod(@NonNull Method method, @NonNull Object[] args) {
            return false;
        }

        public boolean permitsFieldGet(@NonNull Field field, @NonNull Object receiver) {
            if (receiver == null) {
                return false;
            }
            Package aPackage = receiver.getClass().getPackage();
            if (aPackage == null) {
                return false;
            }
            return aPackage.getName().equals(ReadMavenPomStep.ORG_APACHE_MAVEN_MODEL);
        }

        public boolean permitsFieldSet(@NonNull Field field, @NonNull Object receiver, Object value) {
            if (receiver == null) {
                return false;
            }
            Package aPackage = receiver.getClass().getPackage();
            if (aPackage == null) {
                return false;
            }
            return aPackage.getName().equals(ReadMavenPomStep.ORG_APACHE_MAVEN_MODEL);
        }

        public boolean permitsStaticFieldGet(@NonNull Field field) {
            return false;
        }

        public boolean permitsStaticFieldSet(@NonNull Field field, Object value) {
            return false;
        }
    }

    @Extension(optional=true)
    public static class PackageAutoImporter
    extends GroovyShellDecorator {
        public void customizeImports(CpsFlowExecution context, ImportCustomizer ic) {
            ic.addStarImports(new String[]{ReadMavenPomStep.ORG_APACHE_MAVEN_MODEL});
        }
    }

    public static class Execution
    extends SynchronousNonBlockingStepExecution<Model> {
        private static final long serialVersionUID = 1L;
        private transient ReadMavenPomStep step;

        protected Execution(@NonNull ReadMavenPomStep step, @NonNull StepContext context) {
            super(context);
            this.step = step;
        }

        protected Model run() throws Exception {
            FilePath ws = (FilePath)this.getContext().get(FilePath.class);
            assert (ws != null);
            FilePath path = !StringUtils.isBlank((String)this.step.getFile()) ? ws.child(this.step.getFile()) : ws.child("pom.xml");
            if (!path.exists()) {
                throw new FileNotFoundException(path.getRemote() + " does not exist.");
            }
            if (path.isDirectory()) {
                throw new FileNotFoundException(path.getRemote() + " is a directory.");
            }
            try (InputStream is = path.read();){
                Model model = new MavenXpp3Reader().read(is);
                return model;
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(TaskListener.class, FilePath.class);
        }

        public String getFunctionName() {
            return "readMavenPom";
        }

        @NonNull
        public String getDisplayName() {
            return "Read a maven project file.";
        }
    }
}

