/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.tar;

import com.google.common.collect.ImmutableSet;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.AbstractFileCompressStep;
import org.jenkinsci.plugins.pipeline.utility.steps.tar.TarStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class TarStep
extends AbstractFileCompressStep {
    private boolean compress = true;

    @DataBoundConstructor
    public TarStep(String file) throws Descriptor.FormException {
        if (StringUtils.isBlank((String)file)) {
            throw new Descriptor.FormException("Can not be empty", "file");
        }
        this.setFile(file);
    }

    public boolean isCompress() {
        return this.compress;
    }

    @DataBoundSetter
    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new TarStepExecution(this, context);
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(TaskListener.class, FilePath.class);
        }

        public String getFunctionName() {
            return "tar";
        }

        public String getDisplayName() {
            return "Create Tar file";
        }
    }
}

