/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.toml;

import com.fasterxml.jackson.dataformat.toml.TomlMapper;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.toml.Messages;
import org.jenkinsci.plugins.pipeline.utility.steps.toml.WriteTOMLStepExecution;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class WriteTOMLStep
extends Step {
    private String file;
    private final Object toml;
    private boolean returnText;

    @DataBoundConstructor
    public WriteTOMLStep(Object toml) {
        this.toml = toml;
    }

    @Deprecated
    public WriteTOMLStep(String file, Object toml) {
        this.file = Util.fixNull((String)file);
        this.toml = toml;
    }

    public String getFile() {
        return this.file;
    }

    @DataBoundSetter
    public void setFile(String file) {
        this.file = file;
    }

    public Object getTOML() {
        return this.toml;
    }

    public boolean isReturnText() {
        return this.returnText;
    }

    @DataBoundSetter
    public void setReturnText(boolean returnText) {
        this.returnText = returnText;
    }

    public StepExecution start(StepContext context) throws Exception {
        if (this.toml == null) {
            throw new IllegalArgumentException(Messages.WriteTOMLStepExecution_missingTOML(this.getDescriptor().getFunctionName()));
        }
        if (this.returnText) {
            if (StringUtils.isNotBlank((String)this.file)) {
                throw new IllegalArgumentException(Messages.WriteTOMLStepExecution_bothReturnTextAndFile(this.getDescriptor().getFunctionName()));
            }
            return new ReturnTextExecution(this, context);
        }
        if (StringUtils.isBlank((String)this.file)) {
            throw new IllegalArgumentException(Messages.WriteTOMLStepExecution_missingReturnTextAndFile(this.getDescriptor().getFunctionName()));
        }
        return new WriteTOMLStepExecution(this, context);
    }

    void execute(Writer writer) throws IOException {
        TomlMapper mapper = new TomlMapper();
        mapper.writeValue(writer, this.toml);
    }

    private static class ReturnTextExecution
    extends SynchronousNonBlockingStepExecution<String> {
        private static final long serialVersionUID = 1L;
        private transient WriteTOMLStep step;

        protected ReturnTextExecution(WriteTOMLStep step, @NonNull StepContext context) {
            super(context);
            this.step = step;
        }

        protected String run() throws Exception {
            StringWriter w = new StringWriter();
            this.step.execute(w);
            return w.toString();
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(TaskListener.class);
        }

        public String getFunctionName() {
            return "writeTOML";
        }

        @NonNull
        public String getDisplayName() {
            return Messages.WriteTOMLStep_DescriptorImpl_displayName();
        }
    }
}

