/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.conf;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.model.TaskListener;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationConverter;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.AbstractFileOrTextStepExecution;
import org.jenkinsci.plugins.pipeline.utility.steps.conf.ReadPropertiesStep;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public class ReadPropertiesStepExecution
extends AbstractFileOrTextStepExecution<Map<String, Object>> {
    private static final long serialVersionUID = 1L;
    private transient ReadPropertiesStep step;

    protected ReadPropertiesStepExecution(@NonNull ReadPropertiesStep step, @NonNull StepContext context) {
        super(step, context);
        this.step = step;
    }

    @Override
    protected Map<String, Object> doRun() throws Exception {
        PrintStream logger = this.getLogger();
        Properties properties = new Properties();
        if (this.step.getDefaults() != null) {
            properties.putAll((Map<?, ?>)this.step.getDefaults());
        }
        if (!StringUtils.isBlank((String)this.step.getFile())) {
            FilePath f = this.ws.child(this.step.getFile());
            if (f.exists() && !f.isDirectory()) {
                try (InputStream is = f.read();){
                    properties.load(is);
                }
            } else if (f.isDirectory()) {
                logger.print("warning: ");
                logger.print(f.getRemote());
                logger.println(" is a directory, omitting from properties gathering");
            } else if (!f.exists()) {
                logger.print("warning: ");
                logger.print(f.getRemote());
                logger.println(" does not exist, omitting from properties gathering");
            }
        }
        if (!StringUtils.isBlank((String)this.step.getText())) {
            StringReader sr = new StringReader(this.step.getText());
            properties.load(sr);
        }
        if (this.step.isInterpolate().booleanValue()) {
            logger.println("Interpolation set to true, starting to parse the variable!");
            properties = this.interpolateProperties(properties);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        this.addAll(properties, result);
        return result;
    }

    private void addAll(Map src, Map<String, Object> dst) {
        if (src == null) {
            return;
        }
        for (Map.Entry e : src.entrySet()) {
            dst.put(e.getKey() != null ? e.getKey().toString() : null, e.getValue());
        }
    }

    private Properties interpolateProperties(Properties properties) throws Exception {
        Configuration interpolatedProp;
        if (properties == null) {
            return null;
        }
        PrintStream logger = this.getLogger();
        try {
            Configuration conf = ConfigurationConverter.getConfiguration((Properties)properties);
            interpolatedProp = ((AbstractConfiguration)conf).interpolatedConfiguration();
        }
        catch (Exception e) {
            logger.println("Got exception while interpolating the variables: " + e.getMessage());
            logger.println("Returning the original properties list!");
            return properties;
        }
        return ConfigurationConverter.getProperties((Configuration)interpolatedProp);
    }

    private PrintStream getLogger() throws Exception {
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        assert (listener != null);
        return listener.getLogger();
    }
}

