/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.fs;

import hudson.AbortException;
import hudson.FilePath;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.fs.ComputeHashCallable;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.QueryParameter;

public abstract class FileVerifyHashStep
extends Step {
    private final String file;
    private final String hash;
    private final String hashAlgorithm;

    public FileVerifyHashStep(String file, String hash, @Nonnull String hashAlgorithm) throws Descriptor.FormException {
        if (StringUtils.isBlank((String)file)) {
            throw new Descriptor.FormException("can't be blank", "file");
        }
        if (StringUtils.isBlank((String)hash)) {
            throw new Descriptor.FormException("can't be blank", "hash");
        }
        this.file = file;
        this.hash = hash;
        this.hashAlgorithm = hashAlgorithm;
    }

    public String getFile() {
        return this.file;
    }

    public String getHash() {
        return this.hash;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new ExecutionImpl(this, context);
    }

    public static class ExecutionImpl
    extends SynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        private final transient FileVerifyHashStep step;

        public ExecutionImpl(FileVerifyHashStep step, @Nonnull StepContext context) {
            super(context);
            this.step = step;
        }

        protected Void run() throws Exception {
            FilePath ws = (FilePath)this.getContext().get(FilePath.class);
            FilePath filePath = ws.child(this.step.getFile());
            String calculatedHash = (String)filePath.act((FilePath.FileCallable)new ComputeHashCallable(this.step.getHashAlgorithm()));
            if (calculatedHash == null) {
                throw new FileNotFoundException("File not found: " + this.step.getFile());
            }
            if (!calculatedHash.equalsIgnoreCase(this.step.getHash())) {
                throw new AbortException(this.step.getHashAlgorithm() + " hash mismatch: expected: '" + this.step.getHash() + "', actual: '" + calculatedHash + "'");
            }
            return null;
        }
    }

    public static abstract class DescriptorImpl
    extends StepDescriptor {
        private final String algorithm;

        public DescriptorImpl(String algorithm) {
            this.algorithm = algorithm;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(FilePath.class);
        }

        public String getFunctionName() {
            return "verify" + this.algorithm;
        }

        @Nonnull
        public String getDisplayName() {
            return "Verify the " + this.algorithm.toUpperCase(Locale.ENGLISH) + " of a given file";
        }

        public FormValidation doCheckFile(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"Needs a value");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckHash(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"Needs a value");
            }
            return FormValidation.ok();
        }
    }
}

