/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.fs;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.fs.FileWrapper;
import org.jenkinsci.plugins.pipeline.utility.steps.fs.FindFilesStep;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;

public class FindFilesStepExecution
extends SynchronousNonBlockingStepExecution<FileWrapper[]> {
    private static final long serialVersionUID = 1L;
    @Inject
    private transient FindFilesStep step;

    protected FindFilesStepExecution(@NonNull StepContext context, FindFilesStep step) {
        super(context);
        this.step = step;
    }

    protected FileWrapper[] run() throws Exception {
        FilePath ws = (FilePath)this.getContext().get(FilePath.class);
        assert (ws != null);
        List<FilePath> list = StringUtils.isBlank((String)this.step.getGlob()) ? ws.list() : Arrays.asList(ws.list(this.step.getGlob(), this.step.getExcludes()));
        FileWrapper[] res = new FileWrapper[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            res[i] = new FileWrapper(ws, list.get(i));
        }
        return res;
    }
}

