/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.json;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.AbstractFileOrTextStepExecution;
import org.jenkinsci.plugins.pipeline.utility.steps.json.Messages;
import org.jenkinsci.plugins.pipeline.utility.steps.json.ReadJSONStep;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public class ReadJSONStepExecution
extends AbstractFileOrTextStepExecution<Object> {
    private static final long serialVersionUID = 1L;
    private transient ReadJSONStep step;

    protected ReadJSONStepExecution(@NonNull ReadJSONStep step, @NonNull StepContext context) {
        super(step, context);
        this.step = step;
    }

    @Override
    protected Object doRun() throws Exception {
        String fName = this.step.getDescriptor().getFunctionName();
        if (StringUtils.isNotBlank((String)this.step.getFile()) && StringUtils.isNotBlank((String)this.step.getText())) {
            throw new IllegalArgumentException(Messages.ReadJSONStepExecution_tooManyArguments(fName));
        }
        JSON json = null;
        if (!StringUtils.isBlank((String)this.step.getFile())) {
            FilePath f = this.ws.child(this.step.getFile());
            if (f.exists() && !f.isDirectory()) {
                try (InputStream is = f.read();){
                    json = JSONSerializer.toJSON((Object)IOUtils.toString((InputStream)is, (String)"UTF-8"));
                }
            } else {
                if (f.isDirectory()) {
                    throw new IllegalArgumentException(Messages.JSONStepExecution_fileIsDirectory(f.getRemote()));
                }
                if (!f.exists()) {
                    throw new FileNotFoundException(Messages.JSONStepExecution_fileNotFound(f.getRemote()));
                }
            }
        }
        if (!StringUtils.isBlank((String)this.step.getText())) {
            json = JSONSerializer.toJSON((Object)this.step.getText().trim());
        }
        if (this.step.getReturnPojo()) {
            return this.transformToJavaLangStructures(json);
        }
        return json;
    }

    private Object transformToJavaLangStructures(Object object) {
        if (this.isNull(object)) {
            return null;
        }
        if (object instanceof JSONArray) {
            return this.transformToArrayList((JSONArray)object);
        }
        if (object instanceof JSONObject) {
            return this.transformToLinkedHashMap((JSONObject)object);
        }
        return object;
    }

    private List<Object> transformToArrayList(JSONArray array) {
        ArrayList<Object> result = new ArrayList<Object>(array.size());
        for (Object arrayItem : array) {
            result.add(this.transformToJavaLangStructures(arrayItem));
        }
        return result;
    }

    private Map<String, Object> transformToLinkedHashMap(JSONObject object) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry objectEntry : object.entrySet()) {
            result.put((String)objectEntry.getKey(), this.transformToJavaLangStructures(objectEntry.getValue()));
        }
        return result;
    }

    private boolean isNull(Object value) {
        if (value instanceof JSONNull) {
            return true;
        }
        if (value instanceof JSONObject) {
            try {
                ((Map)value).get("somekey");
            }
            catch (JSONException e) {
                return true;
            }
        }
        return false;
    }
}

