/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pubsub;

import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.security.AccessControlled;
import java.util.Collection;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.pubsub.EventProps;
import org.jenkinsci.plugins.pubsub.JobChannelMessage;
import org.jenkinsci.plugins.pubsub.Message;

public final class RunMessage
extends JobChannelMessage<RunMessage> {
    private static final long serialVersionUID = -1L;
    transient Run run;
    private transient boolean runLookupComplete = false;

    public RunMessage() {
    }

    public RunMessage(@Nonnull Run run) {
        super((Item)run.getParent());
        this.run = run;
        this.set(EventProps.Jenkins.jenkins_object_name, run.getDisplayName());
        this.set(EventProps.Jenkins.jenkins_object_id, run.getId());
        this.set(EventProps.Jenkins.jenkins_object_url, run.getUrl());
        this.set(EventProps.Job.job_run_queueId, Long.toString(run.getQueueId()));
        Result result = run.getResult();
        if (result != null) {
            this.set(EventProps.Job.job_run_status, result.toString());
        } else {
            this.set(EventProps.Job.job_run_status, "RUNNING");
        }
    }

    @Override
    public Message clone() {
        RunMessage clone = new RunMessage();
        clone.putAll((Map<?, ?>)this);
        return clone;
    }

    @Override
    protected AccessControlled getAccessControlled() {
        return this.getRun();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public synchronized Run getRun() {
        if (this.runLookupComplete || this.run != null) {
            return this.run;
        }
        try {
            Item item = this.getJobChannelItem();
            if (item instanceof Job) {
                Collection allJobs;
                Job job = (Job)item;
                String buildId = this.getObjectId();
                if (buildId != null && (allJobs = job.getAllJobs()) != null && !allJobs.isEmpty()) {
                    this.run = ((Job)allJobs.iterator().next()).getBuild(buildId);
                }
            }
        }
        finally {
            this.runLookupComplete = true;
        }
        return this.run;
    }
}

