/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pubsub.listeners;

import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.pubsub.Events;
import org.jenkinsci.plugins.pubsub.Message;
import org.jenkinsci.plugins.pubsub.MessageException;
import org.jenkinsci.plugins.pubsub.PubsubBus;
import org.jenkinsci.plugins.pubsub.RunMessage;

@Extension
public class SyncRunListener
extends RunListener<Run<?, ?>> {
    private static final Logger LOGGER = Logger.getLogger(SyncRunListener.class.getName());

    public void onStarted(Run<?, ?> run, TaskListener listener) {
        try {
            PubsubBus.getBus().publish((Message)new RunMessage(run).setEventName(Events.JobChannel.job_run_started));
        }
        catch (MessageException e) {
            LOGGER.log(Level.WARNING, "Error publishing Run start event.", e);
        }
    }

    public void onFinalized(Run<?, ?> run) {
        try {
            PubsubBus.getBus().publish((Message)new RunMessage(run).setEventName(Events.JobChannel.job_run_ended));
        }
        catch (MessageException e) {
            LOGGER.log(Level.WARNING, "Error publishing Run end event.", e);
        }
    }
}

