/*
 * The MIT License
 *
 * Copyright (c) 2017, CloudBees, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.jenkinsci.plugins.pubsub;

import hudson.model.Item;
import hudson.model.Queue;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

/**
 * Queue task job channel event message.
 * 
 * @author <a href="mailto:tom.fennelly@gmail.com">tom.fennelly@gmail.com</a>
 */
public final class QueueTaskMessage extends JobChannelMessage<QueueTaskMessage> {

    private static final long serialVersionUID = -1L;

    transient Queue.Item queueItem;

    public QueueTaskMessage() {
    }

    public QueueTaskMessage(@Nonnull Queue.Item item, @Nonnull Item jobChannelItem) {
        super(jobChannelItem);
        this.queueItem = item;
    }

    @CheckForNull
    public Queue.Item getQueueItem() {
        return queueItem;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Message clone() {
        Message clone = new QueueTaskMessage();
        clone.putAll(this);
        return clone;
    }
}
