/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pubsub;

import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.acegisecurity.AccessDeniedException;
import org.jenkinsci.plugins.pubsub.Message;

abstract class AccessControlledMessage<T extends AccessControlledMessage>
extends Message
implements AccessControlled {
    AccessControlledMessage() {
    }

    @Nonnull
    protected abstract Permission getRequiredPermission();

    @CheckForNull
    protected abstract AccessControlled getAccessControlled();

    @Nonnull
    public ACL getACL() {
        AccessControlled eventItem = this.getAccessControlled();
        if (eventItem != null) {
            return eventItem.getACL();
        }
        return Jenkins.get().getAuthorizationStrategy().getRootACL();
    }

    public void checkPermission(@Nonnull Permission permission) throws AccessDeniedException {
        if (this.isUnknownToJenkins()) {
            throw new AccessDeniedException(String.format("Jenkins Object '%s' Unknown.", this.getObjectName()));
        }
        this.getACL().checkPermission(permission);
    }

    public boolean hasPermission(@Nonnull Permission permission) {
        if (this.isUnknownToJenkins()) {
            return false;
        }
        return this.getACL().hasPermission(permission);
    }

    private boolean isUnknownToJenkins() {
        return this.getAccessControlled() == null;
    }
}

