/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pubsub;

import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import hudson.security.ACL;
import hudson.util.CopyOnWriteMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.pubsub.AccessControlledMessage;
import org.jenkinsci.plugins.pubsub.ChannelPublisher;
import org.jenkinsci.plugins.pubsub.ChannelSubscriber;
import org.jenkinsci.plugins.pubsub.EventFilter;
import org.jenkinsci.plugins.pubsub.Message;
import org.jenkinsci.plugins.pubsub.PubsubBus;

public final class GuavaPubsubBus
extends PubsubBus {
    private final Map<String, EventBus> channels = new CopyOnWriteMap.Hash();
    private final Map<ChannelSubscriber, GuavaSubscriber> subscribers = new CopyOnWriteMap.Hash();
    private ExecutorService executor;
    private final int MAX_THREADS = Integer.getInteger(GuavaPubsubBus.class.getName() + ".MAX_THREADS", 5);

    public GuavaPubsubBus() {
        this.start();
    }

    @Override
    @Nonnull
    protected ChannelPublisher publisher(@Nonnull String channelName) {
        EventBus channelBus = this.getChannelBus(channelName);
        return arg_0 -> ((EventBus)channelBus).post(arg_0);
    }

    @Override
    public void subscribe(@Nonnull String channelName, @Nonnull ChannelSubscriber subscriber, @Nonnull Authentication authentication, @CheckForNull EventFilter eventFilter) {
        GuavaSubscriber guavaSubscriber = new GuavaSubscriber(subscriber, authentication, eventFilter);
        EventBus channelBus = this.getChannelBus(channelName);
        channelBus.register((Object)guavaSubscriber);
        this.subscribers.put(subscriber, guavaSubscriber);
    }

    @Override
    public void unsubscribe(@Nonnull String channelName, @Nonnull ChannelSubscriber subscriber) {
        GuavaSubscriber guavaSubscriber = this.subscribers.remove(subscriber);
        if (guavaSubscriber != null) {
            EventBus channelBus = this.getChannelBus(channelName);
            channelBus.register((Object)guavaSubscriber);
            channelBus.unregister((Object)guavaSubscriber);
        }
    }

    @Override
    public void start() {
        if (this.executor != null && !this.executor.isShutdown()) {
            return;
        }
        this.executor = new ThreadPoolExecutor(0, this.MAX_THREADS, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), r -> new Thread(r, "GuavaPubsubBus.ThreadPoolExecutor"));
    }

    @Override
    public void shutdown() {
        if (!this.executor.isShutdown()) {
            this.executor.shutdown();
        }
    }

    private EventBus getChannelBus(String channelName) {
        EventBus channelBus = this.channels.get(channelName);
        if (channelBus == null) {
            channelBus = new AsyncEventBus(channelName, (Executor)this.executor);
            this.channels.put(channelName, channelBus);
        }
        return channelBus;
    }

    private static class GuavaSubscriber {
        private ChannelSubscriber subscriber;
        private Authentication authentication;
        private final EventFilter eventFilter;

        public GuavaSubscriber(@Nonnull ChannelSubscriber subscriber, Authentication authentication, EventFilter eventFilter) {
            this.subscriber = subscriber;
            this.authentication = authentication != null ? authentication : Jenkins.ANONYMOUS;
            this.eventFilter = eventFilter;
        }

        @Subscribe
        public void onMessage(@Nonnull Message message) {
            if (this.eventFilter != null && !message.containsAll(this.eventFilter)) {
                return;
            }
            if (message instanceof AccessControlledMessage) {
                if (this.authentication != null) {
                    AccessControlledMessage accMessage = (AccessControlledMessage)message;
                    ACL.impersonate((Authentication)this.authentication, () -> {
                        if (accMessage.hasPermission(accMessage.getRequiredPermission())) {
                            this.subscriber.onMessage(message.clone());
                        }
                    });
                }
            } else {
                this.subscriber.onMessage(message.clone());
            }
        }
    }
}

