/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pubsub;

import hudson.model.Item;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import org.jenkinsci.plugins.pubsub.AccessControlledMessage;
import org.jenkinsci.plugins.pubsub.EventProps;
import org.jenkinsci.plugins.pubsub.Message;

public abstract class JobChannelMessage<T extends JobChannelMessage>
extends AccessControlledMessage {
    private static final Logger LOGGER = Logger.getLogger(JobChannelMessage.class.getName());
    transient Item jobChannelItem;
    private transient boolean jobLookupComplete = false;

    JobChannelMessage() {
        this.setChannelName("job");
    }

    public JobChannelMessage(@Nonnull Item jobChannelItem) {
        this.setJobChannelItem(jobChannelItem);
    }

    @Override
    public final String getChannelName() {
        return "job";
    }

    public final Message setChannelName(String name) {
        return super.setChannelName("job");
    }

    public String getJobName() {
        return this.get(EventProps.Job.job_name);
    }

    @CheckForNull
    public synchronized Item getJobChannelItem() {
        if (this.jobLookupComplete || this.jobChannelItem != null) {
            return this.jobChannelItem;
        }
        try {
            String jobName = this.get(EventProps.Job.job_name);
            if (jobName != null) {
                Jenkins jenkins = Jenkins.get();
                this.jobChannelItem = jenkins.getItemByFullName(jobName);
            }
        }
        finally {
            this.jobLookupComplete = true;
        }
        return this.jobChannelItem;
    }

    @CheckForNull
    public synchronized ParameterizedJobMixIn.ParameterizedJob getJob() {
        LOGGER.warning(String.format("Unexpected call to deprecated method: %s.getJob(). Switch to using getJobChannelItem().", JobChannelMessage.class.getName()));
        if (this.jobChannelItem == null) {
            return null;
        }
        if (this.jobChannelItem instanceof ParameterizedJobMixIn.ParameterizedJob) {
            return (ParameterizedJobMixIn.ParameterizedJob)this.jobChannelItem;
        }
        return null;
    }

    private synchronized void setJobChannelItem(@Nonnull Item jobChannelItem) {
        this.jobChannelItem = jobChannelItem;
        super.setChannelName("job");
        this.set(EventProps.Job.job_name, jobChannelItem.getFullName());
        this.setItemProps(jobChannelItem);
    }

    @Override
    protected AccessControlled getAccessControlled() {
        return this.getJobChannelItem();
    }

    @Override
    @Nonnull
    protected Permission getRequiredPermission() {
        return Item.READ;
    }
}

