/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pubsub;

import hudson.ExtensionList;
import hudson.ExtensionListListener;
import hudson.ExtensionPoint;
import hudson.security.AccessControlled;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.pubsub.AbstractChannelSubscriber;
import org.jenkinsci.plugins.pubsub.AccessControlledMessage;
import org.jenkinsci.plugins.pubsub.ChannelPublisher;
import org.jenkinsci.plugins.pubsub.ChannelSubscriber;
import org.jenkinsci.plugins.pubsub.EventFilter;
import org.jenkinsci.plugins.pubsub.EventProps;
import org.jenkinsci.plugins.pubsub.GuavaPubsubBus;
import org.jenkinsci.plugins.pubsub.Message;
import org.jenkinsci.plugins.pubsub.MessageEnricher;
import org.jenkinsci.plugins.pubsub.MessageException;
import org.jenkinsci.plugins.pubsub.listeners.SyncQueueListener;

public abstract class PubsubBus
implements ExtensionPoint {
    private static final Logger LOGGER = Logger.getLogger(PubsubBus.class.getName());
    private static List<AbstractChannelSubscriber> autoSubscribers = new CopyOnWriteArrayList<AbstractChannelSubscriber>();

    @Nonnull
    public static PubsubBus getBus() {
        return Holder.pubsubBus;
    }

    public void publish(@Nonnull Message message) throws MessageException {
        ExtensionList messageEnrichers;
        AccessControlled accessControlled;
        String channelName = message.getChannelName();
        String eventName = message.getEventName();
        if (channelName == null || channelName.length() == 0) {
            throw new MessageException(String.format("Channel name property '%s' not set on the Message instance.", new Object[]{EventProps.Jenkins.jenkins_channel}));
        }
        if (eventName == null || eventName.length() == 0) {
            throw new MessageException(String.format("Event name property '%s' not set on the Message instance.", new Object[]{EventProps.Jenkins.jenkins_event}));
        }
        message.setChannelName(channelName);
        if (message instanceof AccessControlledMessage && (accessControlled = ((AccessControlledMessage)message).getAccessControlled()) != null) {
            message.set(EventProps.Jenkins.jenkins_object_type, accessControlled.getClass().getName());
        }
        if (!(messageEnrichers = ExtensionList.lookup(MessageEnricher.class)).isEmpty()) {
            for (MessageEnricher enricher : messageEnrichers) {
                try {
                    enricher.enrich(message);
                }
                catch (Exception e) {
                    throw new MessageException(String.format("Event enrichment failure due to unexpected exception in %s.", enricher.getClass().getName()), e);
                }
            }
        }
        this.publisher(channelName).publish(message);
    }

    @Nonnull
    protected abstract ChannelPublisher publisher(@Nonnull String var1);

    public abstract void subscribe(@Nonnull String var1, @Nonnull ChannelSubscriber var2, @Nonnull Authentication var3, @CheckForNull EventFilter var4);

    public abstract void unsubscribe(@Nonnull String var1, @Nonnull ChannelSubscriber var2);

    public abstract void shutdown();

    public void start() {
    }

    private static synchronized void registerAutoChannelSubscribers(PubsubBus pubsubBus) {
        CopyOnWriteArrayList<AbstractChannelSubscriber> newAutoSubscribersList = new CopyOnWriteArrayList<AbstractChannelSubscriber>();
        ExtensionList subscribers = ExtensionList.lookup(AbstractChannelSubscriber.class);
        for (AbstractChannelSubscriber subscriber : subscribers) {
            if (!autoSubscribers.contains(subscriber)) {
                pubsubBus.subscribe(subscriber.getChannelName(), subscriber, subscriber.getAuthentication(), subscriber.getEventFilter());
            }
            newAutoSubscribersList.add(subscriber);
        }
        autoSubscribers = newAutoSubscribersList;
    }

    private static synchronized void unregisterAutoChannelSubscribers(PubsubBus pubsubBus) {
        for (AbstractChannelSubscriber subscriber : autoSubscribers) {
            try {
                pubsubBus.unsubscribe(subscriber.getChannelName(), subscriber);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error doing auto unsubscribe.", e);
            }
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                SyncQueueListener.shutdown();
            }
            finally {
                if (Holder.pubsubBus != null) {
                    try {
                        PubsubBus.unregisterAutoChannelSubscribers(Holder.pubsubBus);
                    }
                    finally {
                        Holder.pubsubBus.shutdown();
                    }
                }
            }
        }));
    }

    private static final class Holder {
        static final PubsubBus pubsubBus;

        private Holder() {
        }

        static {
            ExtensionList installedBusImpls = ExtensionList.lookup(PubsubBus.class);
            pubsubBus = !installedBusImpls.isEmpty() ? (PubsubBus)installedBusImpls.get(0) : new GuavaPubsubBus();
            PubsubBus.registerAutoChannelSubscribers(Holder.pubsubBus);
            ExtensionList.lookup(AbstractChannelSubscriber.class).addListener(new ExtensionListListener(){

                public void onChange() {
                    PubsubBus.registerAutoChannelSubscribers(pubsubBus);
                }
            });
        }
    }
}

